/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython;

import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.resource.Resources;
import org.apache.log4j.Logger;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class PythonInterpreter
extends org.python.util.PythonInterpreter {
    private Logger log = LogFactory.getLogger(LogCategory.OPERATION, ((Object)((Object)this)).getClass());
    private Resources resources = new Resources();

    protected PythonInterpreter() {
    }

    private PythonInterpreter(PyObject dict, PySystemState systemState) {
        super(dict, systemState);
    }

    public void set(String name, Object value) {
        super.set(name, value);
        this.resources.add(value);
    }

    public void set(String name, PyObject value) {
        super.set(name, value);
        this.resources.add(value);
    }

    public void addToPath(String ... pathElements) {
        if (pathElements != null) {
            PyList pyPath = this.getSystemState().path;
            String[] stringArray = pathElements;
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                String pathElement = stringArray[n2];
                PyString pyPathElement = new PyString(pathElement);
                if (!pyPath.contains((Object)pyPathElement)) {
                    pyPath.add((Object)pyPathElement);
                }
                ++n2;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Python path: " + this.getSystemState().path);
        }
    }

    public void removeFromPath(String ... pathElements) {
        if (pathElements != null) {
            PyList pyPath = this.getSystemState().path;
            String[] stringArray = pathElements;
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                String pathElement = stringArray[n2];
                PyString pyPathElement = new PyString(pathElement);
                if (pyPath.contains((Object)pyPathElement)) {
                    pyPath.remove((PyObject)new PyString(pathElement));
                }
                ++n2;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Python path: " + this.getSystemState().path);
        }
    }

    public void releaseResources() {
        this.resources.release();
    }

    public static PythonInterpreter createIsolatedPythonInterpreter() {
        return new PythonInterpreter(null, new PySystemState());
    }

    public static PythonInterpreter createNonIsolatedPythonInterpreter() {
        return new PythonInterpreter();
    }

    public void exec(String data, String filename) {
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath(filename);
        try {
            this.addToPath(pythonPath);
            this.setSystemState();
            Py.exec((PyObject)Py.compile_flags((String)data, (String)filename, (CompileMode)CompileMode.exec, (CompilerFlags)this.cflags), (PyObject)this.getLocals(), null);
            Py.flushLine();
        }
        finally {
            this.removeFromPath(pythonPath);
        }
    }
}

