/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.db.Script;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IDatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.ISqlScriptProvider;
import ch.systemsx.cisd.dbmigration.LogEntry;
import ch.systemsx.cisd.dbmigration.SqlScriptProvider;
import ch.systemsx.cisd.dbmigration.java.IMigrationStepExecutor;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class DBMigrationEngine {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DBMigrationEngine.class);
    private final boolean shouldCreateFromScratch;
    private final ISqlScriptProvider scriptProvider;
    private final IDatabaseAdminDAO adminDAO;
    private final IDatabaseVersionLogDAO logDAO;
    private final ISqlScriptExecutor scriptExecutor;
    private final IMigrationStepExecutor migrationStepExecutor;
    private final IMigrationStepExecutor migrationStepExecutorAdmin;

    public static final ISqlScriptProvider createOrMigrateDatabaseAndGetScriptProvider(DatabaseConfigurationContext context, String databaseVersion) {
        assert (context != null) : "Unspecified database configuration context.";
        assert (StringUtils.isNotBlank((String)databaseVersion)) : "Unspecified database version.";
        IDAOFactory migrationDAOFactory = context.createDAOFactory();
        String databaseEngineCode = context.getDatabaseEngineCode();
        SqlScriptProvider sqlScriptProvider = new SqlScriptProvider(context.getSqlScriptFolders(), databaseEngineCode);
        DBMigrationEngine migrationEngine = new DBMigrationEngine(migrationDAOFactory, sqlScriptProvider, context.isCreateFromScratch());
        migrationEngine.migrateTo(databaseVersion);
        migrationEngine.adminDAO.initializeErrorCodes();
        return sqlScriptProvider;
    }

    public DBMigrationEngine(IDAOFactory daoFactory, ISqlScriptProvider scriptProvider, boolean shouldCreateFromScratch) {
        this.adminDAO = daoFactory.getDatabaseDAO();
        this.logDAO = daoFactory.getDatabaseVersionLogDAO();
        this.scriptExecutor = daoFactory.getSqlScriptExecutor();
        this.migrationStepExecutor = daoFactory.getMigrationStepExecutor();
        this.migrationStepExecutorAdmin = daoFactory.getMigrationStepExecutorAdmin();
        this.scriptProvider = scriptProvider;
        this.shouldCreateFromScratch = shouldCreateFromScratch;
    }

    public final void migrateTo(String version) {
        if (this.shouldCreateFromScratch) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Dropping database.");
            }
            this.adminDAO.dropDatabase();
        }
        if (!this.databaseExists()) {
            this.setupDatabase(version);
            return;
        }
        LogEntry entry = this.getAndCheckLastLogEntry();
        String databaseVersion = entry.getVersion();
        if ("0".equals(databaseVersion)) {
            this.executeSchemaScript(version);
            this.fillWithInitialData(version);
            return;
        }
        if (version.equals(databaseVersion)) {
            if (operationLog.isDebugEnabled()) {
                String databaseName = this.adminDAO.getDatabaseName();
                operationLog.debug("No migration needed for database '" + databaseName + "'. It has the right version (" + version + ").");
            }
        } else if (version.compareTo(databaseVersion) > 0) {
            String databaseName;
            this.adminDAO.createGroups();
            if (operationLog.isInfoEnabled()) {
                databaseName = this.adminDAO.getDatabaseName();
                operationLog.info("Trying to migrate database '" + databaseName + "' from version " + databaseVersion + " to " + version + ".");
            }
            this.migrate(databaseVersion, version);
            if (operationLog.isInfoEnabled()) {
                databaseName = this.adminDAO.getDatabaseName();
                operationLog.info("Database '" + databaseName + "' successfully migrated from version " + databaseVersion + " to " + version + ".");
            }
        } else {
            String databaseName = this.adminDAO.getDatabaseName();
            String message = "Cannot revert database '" + databaseName + "' from version " + databaseVersion + " to earlier version " + version + ".";
            operationLog.error(message);
            throw new EnvironmentFailureException(message);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("Using database '%s'", this.adminDAO.getDatabaseURL()));
        }
    }

    private final LogEntry getAndCheckLastLogEntry() {
        LogEntry entry = this.logDAO.getLastEntry();
        if (entry == null) {
            operationLog.error("Inconsistent database: Empty database version log.");
            throw new EnvironmentFailureException("Inconsistent database: Empty database version log.");
        }
        if (entry.getRunStatus() != LogEntry.RunStatus.SUCCESS) {
            String message = "Inconsistent database: Last creation/migration didn't succeed. Last log entry: " + entry;
            operationLog.error(message);
            throw new EnvironmentFailureException(message);
        }
        return entry;
    }

    private final void setupDatabase(String version) {
        this.adminDAO.createOwner();
        this.adminDAO.createGroups();
        if (this.scriptProvider.isDumpRestore(version)) {
            this.adminDAO.restoreDatabaseFromDump(this.scriptProvider.getDumpFolder(version), version);
        } else {
            this.createEmptyDatabase(version);
            this.fillWithInitialData(version);
        }
        if (operationLog.isInfoEnabled()) {
            String databaseName = this.adminDAO.getDatabaseName();
            operationLog.info("Database '" + databaseName + "' version " + version + " has been successfully created.");
        }
    }

    private final void createEmptyDatabase(String version) {
        this.adminDAO.createDatabase();
        this.executeSchemaScript(version);
    }

    private final void executeSchemaScript(String version) {
        Script domainsScript = this.scriptProvider.tryGetDomainsScript(version);
        if (domainsScript == null) {
            operationLog.debug("No domains script found for version " + version);
        } else {
            this.scriptExecutor.execute(domainsScript, true, this.logDAO);
        }
        Script schemaScript = this.scriptProvider.tryGetSchemaScript(version);
        if (schemaScript == null) {
            String message = "No schema script found for version " + version;
            operationLog.error(message);
            throw new ConfigurationFailureException(message);
        }
        this.scriptExecutor.execute(schemaScript, true, this.logDAO);
        Script functionScript = this.scriptProvider.tryGetFunctionScript(version);
        if (functionScript == null) {
            operationLog.debug("No function script found for version " + version);
        } else {
            this.scriptExecutor.execute(functionScript, false, this.logDAO);
        }
        Script grantsScript = this.scriptProvider.tryGetGrantsScript(version);
        if (grantsScript == null) {
            operationLog.debug("No grants script found for version " + version);
        } else {
            this.scriptExecutor.execute(grantsScript, true, this.logDAO);
        }
    }

    private final void fillWithInitialData(String version) {
        Script initialDataScript = this.scriptProvider.tryGetDataScript(version);
        if (initialDataScript != null) {
            this.scriptExecutor.execute(initialDataScript, true, this.logDAO);
        }
    }

    private final void migrate(String fromVersion, String toVersion) {
        String nextVersion;
        String version = fromVersion;
        do {
            nextVersion = DBMigrationEngine.increment(version);
            Script functionMigrationScriptOrNull = this.scriptProvider.tryGetFunctionMigrationScript(version, nextVersion);
            Script migrationScript = this.scriptProvider.tryGetMigrationScript(version, nextVersion);
            if (migrationScript == null) {
                String databaseName = this.adminDAO.getDatabaseName();
                String message = "Cannot migrate database '" + databaseName + "' from version " + version + " to " + nextVersion + " because of missing migration script.";
                operationLog.error(message);
                throw new EnvironmentFailureException(message);
            }
            long time = System.currentTimeMillis();
            this.migrationStepExecutorAdmin.init(migrationScript);
            this.migrationStepExecutor.init(migrationScript);
            this.migrationStepExecutorAdmin.performPreMigration();
            this.migrationStepExecutor.performPreMigration();
            this.scriptExecutor.execute(migrationScript, true, this.logDAO);
            if (functionMigrationScriptOrNull != null) {
                this.scriptExecutor.execute(functionMigrationScriptOrNull, false, this.logDAO);
            }
            this.migrationStepExecutor.performPostMigration();
            this.migrationStepExecutorAdmin.performPostMigration();
            this.migrationStepExecutor.finish();
            this.migrationStepExecutorAdmin.finish();
            if (!operationLog.isInfoEnabled()) continue;
            operationLog.info("Successfully migrated from version " + version + " to " + nextVersion + " in " + (System.currentTimeMillis() - time) + " msec");
        } while (!(version = nextVersion).equals(toVersion));
    }

    @Private
    static final String increment(String version) {
        char[] characters = new char[version.length()];
        version.getChars(0, characters.length, characters, 0);
        int i = characters.length - 1;
        while (i >= 0) {
            char c = characters[i];
            if (c != '9') {
                characters[i] = (char)(c + '\u0001');
                break;
            }
            characters[i] = 48;
            --i;
        }
        return new String(characters);
    }

    private final boolean databaseExists() {
        boolean result = this.logDAO.canConnectToDatabase();
        if (!result && operationLog.isInfoEnabled()) {
            operationLog.info("Database '" + this.adminDAO.getDatabaseName() + "' does not exist.");
        }
        return result;
    }
}

