/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.event.BooleanEvent;
import ch.systemsx.cisd.common.logging.event.LongEvent;
import ch.systemsx.cisd.dbmigration.logging.DbConnectionLogConfiguration;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

class MonitoringPoolingDataSource
extends PoolingDataSource {
    private static final long DEFAULT_PERIOD_TIMER_MILLIS = 10000L;
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, MonitoringPoolingDataSource.class);
    private static final Timer infoControlTimer = new Timer("db connection info", true);
    private static DatabaseConnectionInfoController infoController = new DatabaseConnectionInfoController();
    static final Map<Integer, BorrowedConnectionRecord> activeConnections = new ConcurrentHashMap<Integer, BorrowedConnectionRecord>();
    private static volatile boolean logStackTrace;
    private static volatile Level configuredLogLevel;
    private final long activeConnectionsLogInterval;
    private final String url;
    private long lastLogged;
    private int maxActiveSinceLastLogged;

    static {
        infoControlTimer.schedule((TimerTask)infoController, 10000L, 10000L);
    }

    public MonitoringPoolingDataSource(ObjectPool pool, String url, long activeConnectionsLogInterval) {
        super(pool);
        this.activeConnectionsLogInterval = activeConnectionsLogInterval;
        this.url = url;
    }

    public static synchronized void rescheduleInfoController(long periodInMillis) {
        infoController.cancel();
        infoControlTimer.purge();
        infoController = new DatabaseConnectionInfoController();
        infoControlTimer.schedule((TimerTask)infoController, periodInMillis, periodInMillis);
    }

    public static boolean isLogStackTrace() {
        return logStackTrace;
    }

    public static void setLogStackTrace(boolean logStackTrace) {
        MonitoringPoolingDataSource.logStackTrace = logStackTrace;
        machineLog.info(String.valueOf(logStackTrace ? "Enable" : "Disable") + " stacktrace recording for database connections.");
    }

    public static void setLogLevel(Level logLevel) {
        machineLog.setLevel(logLevel);
        configuredLogLevel = logLevel;
        machineLog.info("Set loglevel to " + logLevel + ".");
    }

    static void logActiveDatabaseConnections(long oldActiveConnTimeMillis) {
        long now = System.currentTimeMillis();
        StringBuilder out = new StringBuilder();
        ArrayList<BorrowedConnectionRecord> records = new ArrayList<BorrowedConnectionRecord>(activeConnections.values());
        Collections.sort(records, new Comparator<BorrowedConnectionRecord>(){

            @Override
            public int compare(BorrowedConnectionRecord o1, BorrowedConnectionRecord o2) {
                return (int)(o2.timeOfBorrowing - o1.timeOfBorrowing);
            }
        });
        if (records.isEmpty() || now - ((BorrowedConnectionRecord)records.get((int)0)).timeOfBorrowing < oldActiveConnTimeMillis) {
            out.append(String.format("There are no active database connections older than %d ms.\n", oldActiveConnTimeMillis));
            return;
        }
        out.append(String.format("\n>>>--- %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL ---------------------------------->>>\n", now));
        if (oldActiveConnTimeMillis > 0L) {
            out.append(String.format("Active database connection overview older than %d ms (sorted by age)\n", oldActiveConnTimeMillis));
        } else {
            out.append(String.format("Active database connection overview (sorted by age)\n", new Object[0]));
        }
        out.append(String.format("%-25s\t%-25s\t%-25s\n", "Time", "Thread", "Database"));
        boolean hasStackTraces = false;
        for (BorrowedConnectionRecord record : records) {
            if (now - record.timeOfBorrowing <= oldActiveConnTimeMillis) continue;
            out.append(String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL  \t%2$-25s\t%3$-25s\n", record.timeOfBorrowing, record.threadName, record.dbUrl));
            hasStackTraces |= record.borrowStackTraceOrNull != null;
        }
        if (hasStackTraces) {
            out.append(String.format("\nActive database connection stacktraces", new Object[0]));
            boolean noNewline = true;
            for (BorrowedConnectionRecord record : records) {
                if (now - record.timeOfBorrowing <= oldActiveConnTimeMillis || record.borrowStackTraceOrNull == null) continue;
                if (noNewline) {
                    noNewline = false;
                } else {
                    out.append("\n");
                }
                out.append(String.format("Time: %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n", record.timeOfBorrowing));
                out.append(String.format("Database: %s\n", record.dbUrl));
                out.append(String.format("Thread: %s\n", record.threadName));
                out.append(String.format("Stacktrace:\n" + MonitoringPoolingDataSource.traceToString(record.borrowStackTraceOrNull), new Object[0]));
            }
        }
        out.append(String.format("<<<--- %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL ----------------------------------<<<\n", now));
        machineLog.info(out.toString());
    }

    public Connection getConnection() throws SQLException {
        try {
            Object conn = (Connection)this._pool.borrowObject();
            long now = System.currentTimeMillis();
            int numActive = this._pool.getNumActive();
            this.maxActiveSinceLastLogged = Math.max(this.maxActiveSinceLastLogged, numActive);
            if (this.activeConnectionsLogInterval > 0L && now - this.lastLogged > this.activeConnectionsLogInterval && this.maxActiveSinceLastLogged > 1) {
                if (machineLog.isInfoEnabled()) {
                    machineLog.info(String.format("Active database connections [%s]: current: %d, peak: %d.", this.url, numActive, this.maxActiveSinceLastLogged));
                }
                this.lastLogged = now;
                this.maxActiveSinceLastLogged = 0;
            }
            if (conn != null) {
                conn = new PoolGuardConnectionWrapper((Connection)conn);
                activeConnections.put(System.identityHashCode(conn), new BorrowedConnectionRecord(now, this.url, Thread.currentThread().getName(), (StackTraceElement[])(logStackTrace ? MonitoringPoolingDataSource.getStackTrace() : null)));
            }
            return conn;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("Cannot get a connection, pool error " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot get a connection, general error", (Throwable)e);
        }
    }

    static StackTraceElement[] getStackTrace() {
        Throwable th = new Throwable();
        th.fillInStackTrace();
        return th.getStackTrace();
    }

    static String tryGetServiceMethodName(StackTraceElement[] stackTrace) {
        String innerMethodName = null;
        String outerMethodName = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().contains("$Proxy")) {
                if (innerMethodName == null) {
                    innerMethodName = e.getMethodName();
                }
                outerMethodName = e.getMethodName();
            }
            ++n2;
        }
        if (innerMethodName == null) {
            return null;
        }
        if (innerMethodName.equals(outerMethodName)) {
            return outerMethodName;
        }
        return String.valueOf(outerMethodName) + " / " + innerMethodName;
    }

    static String traceToString(StackTraceElement[] trace) {
        StringBuilder builder = new StringBuilder();
        MonitoringPoolingDataSource.traceToString(builder, trace);
        return builder.toString();
    }

    static void traceToString(StringBuilder builder, StackTraceElement[] trace) {
        boolean skip = true;
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement te = stackTraceElementArray[n2];
            if (skip) {
                skip = false;
            } else {
                builder.append("\tat ");
                builder.append(te.toString());
                builder.append('\n');
            }
            ++n2;
        }
    }

    private static class BorrowedConnectionRecord {
        final long timeOfBorrowing;
        final String dbUrl;
        final String threadName;
        final StackTraceElement[] borrowStackTraceOrNull;

        BorrowedConnectionRecord(long timeOfBorrowing, String dbUrl, String threadName, StackTraceElement[] borrowStackTraceOrNull) {
            this.timeOfBorrowing = timeOfBorrowing;
            this.dbUrl = dbUrl;
            this.threadName = threadName;
            this.borrowStackTraceOrNull = borrowStackTraceOrNull;
        }
    }

    private static class DatabaseConnectionInfoController
    extends TimerTask {
        private DatabaseConnectionInfoController() {
        }

        @Override
        public void run() {
            BooleanEvent debugEvent;
            BooleanEvent stacktraceEvent;
            LongEvent printActiveEvent = DbConnectionLogConfiguration.getInstance().getDbConnectionsPrintActiveEvent();
            if (printActiveEvent != null) {
                long oldActiveConnTimeMillis = printActiveEvent.getValue() != null ? (Long)printActiveEvent.getValue() : 0L;
                MonitoringPoolingDataSource.logActiveDatabaseConnections(oldActiveConnTimeMillis);
            }
            if ((stacktraceEvent = DbConnectionLogConfiguration.getInstance().getDbConnectionsStacktraceEvent()) != null && stacktraceEvent.getValue() != null) {
                MonitoringPoolingDataSource.setLogStackTrace((Boolean)stacktraceEvent.getValue());
            }
            if ((debugEvent = DbConnectionLogConfiguration.getInstance().getDbConnectionsDebugEvent()) != null && debugEvent.getValue() != null) {
                if (((Boolean)debugEvent.getValue()).booleanValue()) {
                    configuredLogLevel = machineLog.getLevel();
                    machineLog.setLevel(Level.DEBUG);
                    machineLog.info("Enable debug log for database connections.");
                } else {
                    Level level = configuredLogLevel;
                    machineLog.setLevel(level == null ? Level.INFO : level);
                    machineLog.info("Disable debug log for database connections.");
                }
            }
        }
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        PoolGuardConnectionWrapper(Connection delegate) {
            super(delegate);
            this.log("Hand out database connection");
        }

        void log(String action) {
            if (machineLog.isDebugEnabled()) {
                int numActive = MonitoringPoolingDataSource.this._pool.getNumActive();
                StackTraceElement[] stackTrace = MonitoringPoolingDataSource.getStackTrace();
                String serviceMethod = MonitoringPoolingDataSource.tryGetServiceMethodName(stackTrace);
                StringBuilder b = new StringBuilder();
                b.append('[');
                b.append(MonitoringPoolingDataSource.this.url);
                b.append("] ");
                b.append(action);
                b.append(", id=");
                b.append(this.hashCode());
                b.append(", active=");
                b.append(numActive);
                if (serviceMethod != null) {
                    b.append(", service method: ");
                    b.append(serviceMethod);
                }
                if (logStackTrace) {
                    b.append(", stacktrace:\n");
                    MonitoringPoolingDataSource.traceToString(b, stackTrace);
                } else {
                    b.append('.');
                }
                machineLog.debug(b.toString());
            }
        }

        protected void checkOpen() throws SQLException {
            if (this._conn == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        public void close() throws SQLException {
            if (this._conn != null) {
                this.log("Return database connection");
                this._conn.close();
                super.setDelegate(null);
                activeConnections.remove(System.identityHashCode((Object)this));
            }
        }

        public boolean isClosed() throws SQLException {
            if (this._conn == null) {
                return true;
            }
            return this._conn.isClosed();
        }

        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this._conn.clearWarnings();
        }

        public void commit() throws SQLException {
            this.checkOpen();
            this._conn.commit();
        }

        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement());
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement(resultSetType, resultSetConcurrency));
        }

        public boolean innermostDelegateEquals(Connection c) {
            Connection innerCon = super.getInnermostDelegate();
            if (innerCon == null) {
                return c == null;
            }
            return innerCon.equals(c);
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this._conn.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this._conn.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this._conn.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this._conn.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            this.checkOpen();
            return this._conn.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this._conn.getWarnings();
        }

        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this._conn.isReadOnly();
        }

        public String nativeSQL(String sql) throws SQLException {
            this.checkOpen();
            return this._conn.nativeSQL(sql);
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency));
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        public void rollback() throws SQLException {
            this.checkOpen();
            this._conn.rollback();
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.checkOpen();
            this._conn.setAutoCommit(autoCommit);
        }

        public void setCatalog(String catalog) throws SQLException {
            this.checkOpen();
            this._conn.setCatalog(catalog);
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.checkOpen();
            this._conn.setReadOnly(readOnly);
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.checkOpen();
            this._conn.setTransactionIsolation(level);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkOpen();
            this._conn.setTypeMap(map);
        }

        public String toString() {
            if (this._conn == null) {
                return "NULL";
            }
            return this._conn.toString();
        }

        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this._conn.getHoldability();
        }

        public void setHoldability(int holdability) throws SQLException {
            this.checkOpen();
            this._conn.setHoldability(holdability);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this._conn.setSavepoint();
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            this.checkOpen();
            return this._conn.setSavepoint(name);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this._conn.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this._conn.rollback(savepoint);
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, autoGeneratedKeys));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, columnIndexes));
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, columnNames));
        }

        public Connection getDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        public Connection getInnermostDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

