/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractPostRegistrationDataSetHandlerForFileBasedUndo
implements IPostRegistrationDatasetHandler {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractPostRegistrationDataSetHandlerForFileBasedUndo.class);
    private final List<File> createdFiles = new ArrayList<File>();
    private final IFileOperations fileOperations;

    protected AbstractPostRegistrationDataSetHandlerForFileBasedUndo(IFileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    protected IFileOperations getFileOperations() {
        return this.fileOperations;
    }

    protected void addFileForUndo(File file) {
        this.createdFiles.add(file);
    }

    @Override
    public void undoLastOperation() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Undo last operation by deleting following files: " + this.createdFiles);
        }
        for (File file : this.createdFiles) {
            if (!file.exists()) continue;
            this.fileOperations.deleteRecursively(file);
        }
    }
}

