/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithm;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IPostRegistrationAction;
import ch.systemsx.cisd.etlserver.IPreRegistrationAction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DataSetRegistrationHelper
implements DataSetRegistrationAlgorithm.IRollbackDelegate {
    @Private
    public static final String EMAIL_SUBJECT_TEMPLATE = "Success: data set for experiment '%s";
    @Private
    static final String DATA_SET_REGISTRATION_FAILURE_TEMPLATE = "Registration of data set '%s' failed.";
    @Private
    static final String DATA_SET_STORAGE_FAILURE_TEMPLATE = "Storing data set '%s' failed.";
    @Private
    static final String SUCCESSFULLY_REGISTERED = "Successfully registered data set: [";
    protected final File incomingDataSetFile;
    protected final DataSetRegistrationAlgorithm registrationAlgorithm;

    public DataSetRegistrationHelper(File incomingDataSetFile, String shareId, IDelegatedActionWithResult<Boolean> cleanAftrewardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction) {
        DataSetInformation dataSetInformation = this.extractDataSetInformation(incomingDataSetFile);
        dataSetInformation.setShareId(shareId);
        IDataStoreStrategy dataStoreStrategy = this.getDataStrategyStore().getDataStoreStrategy(dataSetInformation, incomingDataSetFile);
        DataSetRegistrationAlgorithm.DataSetRegistrationAlgorithmState algorithmState = new DataSetRegistrationAlgorithm.DataSetRegistrationAlgorithmState(incomingDataSetFile, this.getOpenBisService(), cleanAftrewardsAction, preRegistrationAction, postRegistrationAction, dataSetInformation, dataStoreStrategy, this.getTypeExtractor(), this.getStorageProcessor(), this.getFileOperations(), this.getDataSetValidator(), this.getMailClient(), this.shouldDeleteUnidentified(), this.getRegistrationLock(), this.getDataStoreCode(), this.shouldNotifySuccessfulRegistration());
        this.registrationAlgorithm = new DataSetRegistrationAlgorithm(algorithmState, this);
        this.incomingDataSetFile = algorithmState.getIncomingDataSetFile();
    }

    public DataSetRegistrationHelper(File incomingDataSetFile, String shareId, IDelegatedActionWithResult<Boolean> cleanAftrewardsAction, IPreRegistrationAction preRegistrationAction, IPostRegistrationAction postRegistrationAction, DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator appServerRegistrator) {
        DataSetInformation dataSetInformation = this.extractDataSetInformation(incomingDataSetFile);
        dataSetInformation.setShareId(shareId);
        IDataStoreStrategy dataStoreStrategy = this.getDataStrategyStore().getDataStoreStrategy(dataSetInformation, incomingDataSetFile);
        DataSetRegistrationAlgorithm.DataSetRegistrationAlgorithmState algorithmState = new DataSetRegistrationAlgorithm.DataSetRegistrationAlgorithmState(incomingDataSetFile, this.getOpenBisService(), cleanAftrewardsAction, preRegistrationAction, postRegistrationAction, dataSetInformation, dataStoreStrategy, this.getTypeExtractor(), this.getStorageProcessor(), this.getFileOperations(), this.getDataSetValidator(), this.getMailClient(), this.shouldDeleteUnidentified(), this.getRegistrationLock(), this.getDataStoreCode(), this.shouldNotifySuccessfulRegistration());
        this.registrationAlgorithm = new DataSetRegistrationAlgorithm(algorithmState, this, appServerRegistrator);
        this.incomingDataSetFile = algorithmState.getIncomingDataSetFile();
    }

    public DataSetRegistrationAlgorithm getRegistrationAlgorithm() {
        return this.registrationAlgorithm;
    }

    public DataSetInformation getDataSetInformation() {
        return this.registrationAlgorithm.getDataSetInformation();
    }

    public final void prepare() {
        this.registrationAlgorithm.prepare();
    }

    public final boolean hasDataSetBeenIdentified() {
        return this.registrationAlgorithm.hasDataSetBeenIdentified();
    }

    public final List<DataSetInformation> registerDataSet() {
        return this.registrationAlgorithm.registerDataSet();
    }

    public final void dealWithUnidentifiedDataSet() {
        this.registrationAlgorithm.dealWithUnidentifiedDataSet();
    }

    protected DataSetInformation extractDataSetInformation(File incomingDataSetPath) {
        String errorMessage = "Error when trying to identify data set '" + incomingDataSetPath.getAbsolutePath() + "'.";
        DataSetInformation dataSetInfo = null;
        try {
            dataSetInfo = this.getDataSetInfoExtractor().getDataSetInformation(incomingDataSetPath, this.getOpenBisService());
            dataSetInfo.setInstanceCode(this.getHomeDatabaseInstance().getCode());
            dataSetInfo.setInstanceUUID(this.getHomeDatabaseInstance().getUuid());
            if (this.getOperationLog().isDebugEnabled()) {
                this.getOperationLog().debug(String.format("Extracting data set information '%s' from incoming data set path '%s'", dataSetInfo, incomingDataSetPath));
            }
            return dataSetInfo;
        }
        catch (HighLevelException e) {
            String email;
            if (dataSetInfo != null && !StringUtils.isBlank((String)(email = dataSetInfo.tryGetUploadingUserEmail()))) {
                this.getMailClient().sendMessage(errorMessage, e.getMessage(), null, null, email);
            }
            throw e;
        }
        catch (RuntimeException ex) {
            throw new EnvironmentFailureException(errorMessage, ex);
        }
    }

    @Override
    public void rollback(DataSetRegistrationAlgorithm algo, Throwable ex) {
        this.rollback(ex);
    }

    protected abstract void rollback(Throwable var1);

    protected abstract IEncapsulatedOpenBISService getOpenBisService();

    protected abstract ITypeExtractor getTypeExtractor();

    protected abstract IStorageProcessorTransactional getStorageProcessor();

    protected abstract IDataSetInfoExtractor getDataSetInfoExtractor();

    protected abstract DatabaseInstance getHomeDatabaseInstance();

    protected abstract Logger getOperationLog();

    protected abstract Logger getNotificationLog();

    protected abstract IMailClient getMailClient();

    protected abstract IFileOperations getFileOperations();

    protected abstract String getDataStoreCode();

    protected abstract IDataStrategyStore getDataStrategyStore();

    protected abstract IDataSetValidator getDataSetValidator();

    protected abstract Lock getRegistrationLock();

    protected abstract boolean shouldDeleteUnidentified();

    protected abstract boolean shouldNotifySuccessfulRegistration();
}

