/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.DataSetNameEntitiesProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DefaultDataSetInfoExtractor
extends AbstractDataSetInfoExtractor {
    @Private
    static final String SUB_ENTITY_SEPARATOR_PROPERTY_NAME = "sub-entity-separator";
    protected static final char DEFAULT_SUB_ENTITY_SEPARATOR = '&';
    @Private
    static final String INDEX_OF_SAMPLE_CODE = "index-of-sample-code";
    @Private
    static final String INDEX_OF_EXPERIMENT_IDENTIFIER = "index-of-experiment-identifier";
    @Private
    static final String INDEX_OF_PARENT_DATA_SET_CODES = "index-of-parent-data-set-codes";
    private static final int DEFAULT_INDEX_OF_SAMPLE_CODE = -1;
    @Private
    static final String INDEX_OF_GROUP_CODE = "index-of-space-code";
    @Private
    static final String INDEX_OF_DATA_PRODUCER_CODE = "index-of-data-producer-code";
    @Private
    static final String INDEX_OF_DATA_PRODUCTION_DATE = "index-of-data-production-date";
    @Private
    static final String DATA_PRODUCTION_DATE_FORMAT = "data-production-date-format";
    private static final String DEFAULT_DATA_PRODUCTION_DATE_FORMAT = "yyyyMMddHHmmss";
    @Private
    static final String DATA_SET_PROPERTIES_FILE_NAME_KEY = "data-set-properties-file-name";
    private final int indexOfSampleCode;
    private final Index indexOfExperimentIdentifier;
    private final Index indexOfGroupCode;
    protected final Index indexOfParentDataSetCodes;
    private final Index indexOfDataProducerCode;
    private final Index indexOfDataProductionDate;
    private final SimpleDateFormat dateFormat;
    private final String dataSetPropertiesFileNameOrNull;
    private final char subEntitySeparator;

    public DefaultDataSetInfoExtractor(Properties properties) {
        super(properties);
        this.subEntitySeparator = PropertyUtils.getChar(properties, SUB_ENTITY_SEPARATOR_PROPERTY_NAME, '&');
        if (Character.isWhitespace(this.subEntitySeparator)) {
            throw new ConfigurationFailureException("Sub entity separator is a whitespace character.");
        }
        if (this.subEntitySeparator == this.entitySeparator) {
            throw new ConfigurationFailureException("Entity separator '" + this.entitySeparator + "' and sub entity separator '" + this.subEntitySeparator + "' have to be different.");
        }
        this.indexOfSampleCode = PropertyUtils.getInt(properties, INDEX_OF_SAMPLE_CODE, -1);
        this.indexOfExperimentIdentifier = new Index(properties, INDEX_OF_EXPERIMENT_IDENTIFIER);
        this.indexOfGroupCode = new Index(properties, INDEX_OF_GROUP_CODE);
        this.indexOfParentDataSetCodes = new Index(properties, INDEX_OF_PARENT_DATA_SET_CODES);
        this.indexOfDataProducerCode = new Index(properties, INDEX_OF_DATA_PRODUCER_CODE);
        this.indexOfDataProductionDate = new Index(properties, INDEX_OF_DATA_PRODUCTION_DATE);
        this.dateFormat = new SimpleDateFormat(properties.getProperty(DATA_PRODUCTION_DATE_FORMAT, DEFAULT_DATA_PRODUCTION_DATE_FORMAT));
        this.dataSetPropertiesFileNameOrNull = properties.getProperty(DATA_SET_PROPERTIES_FILE_NAME_KEY);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws EnvironmentFailureException, UserFailureException {
        assert (incomingDataSetPath != null) : "Incoming data set path can not be null.";
        DataSetNameEntitiesProvider entitiesProvider = new DataSetNameEntitiesProvider(incomingDataSetPath, this.entitySeparator, this.stripExtension);
        DataSetInformation dataSetInformation = new DataSetInformation();
        String groupCode = this.extractGroupCode(entitiesProvider);
        ExperimentIdentifier experimentIdentifier = this.tryToExtractExperimentIdentifier(entitiesProvider, groupCode);
        dataSetInformation.setExperimentIdentifier(experimentIdentifier);
        if (experimentIdentifier == null) {
            dataSetInformation.setSampleCode(this.extractSampleCode(entitiesProvider));
        }
        dataSetInformation.setParentDataSetCodes(this.getParentDataSetCodes(entitiesProvider));
        dataSetInformation.setProducerCode(this.tryGetDataProducerCode(entitiesProvider));
        dataSetInformation.setProductionDate(this.tryGetDataProductionDate(entitiesProvider));
        dataSetInformation.setDataSetProperties(DefaultDataSetInfoExtractor.extractDataSetProperties(incomingDataSetPath, this.dataSetPropertiesFileNameOrNull));
        dataSetInformation.setSpaceCode(groupCode);
        return dataSetInformation;
    }

    private ExperimentIdentifier tryToExtractExperimentIdentifier(DataSetNameEntitiesProvider entitiesProvider, String groupCode) {
        if (this.indexOfExperimentIdentifier.isUndefined()) {
            return null;
        }
        String experimentIdentifier = entitiesProvider.getEntity(this.indexOfExperimentIdentifier.getIndex());
        String[] codes = StringUtils.split((String)experimentIdentifier, (char)this.subEntitySeparator);
        ExperimentIdentifier identifier = new ExperimentIdentifier();
        if (codes.length > 0) {
            identifier.setExperimentCode(codes[codes.length - 1]);
        }
        if (codes.length > 1) {
            identifier.setProjectCode(codes[codes.length - 2]);
        }
        identifier.setSpaceCode(codes.length > 2 ? codes[codes.length - 3] : groupCode);
        return identifier;
    }

    private String extractSampleCode(DataSetNameEntitiesProvider entitiesProvider) {
        String sampleCode = entitiesProvider.getEntity(this.indexOfSampleCode);
        return sampleCode.replace(this.subEntitySeparator, ':');
    }

    private List<String> getParentDataSetCodes(DataSetNameEntitiesProvider entitiesProvider) {
        if (this.indexOfParentDataSetCodes.isUndefined()) {
            return Collections.emptyList();
        }
        String parentDataSetCodes = entitiesProvider.getEntity(this.indexOfParentDataSetCodes.getIndex(), false);
        String[] codes = StringUtils.split((String)parentDataSetCodes, (char)this.subEntitySeparator);
        return Arrays.asList(codes);
    }

    private String extractGroupCode(DataSetNameEntitiesProvider entitiesProvider) {
        if (this.indexOfGroupCode.isUndefined()) {
            return super.getGroupCode();
        }
        return entitiesProvider.getEntity(this.indexOfGroupCode.getIndex());
    }

    private String tryGetDataProducerCode(DataSetNameEntitiesProvider dataSetNameEntitiesProvider) {
        if (this.indexOfDataProducerCode.isUndefined()) {
            return null;
        }
        return dataSetNameEntitiesProvider.getEntity(this.indexOfDataProducerCode.getIndex());
    }

    private Date tryGetDataProductionDate(DataSetNameEntitiesProvider dataSetNameEntitiesProvider) {
        if (this.indexOfDataProductionDate.isUndefined()) {
            return null;
        }
        String dateString = dataSetNameEntitiesProvider.getEntity(this.indexOfDataProductionDate.getIndex());
        try {
            return this.dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            throw new UserFailureException("Could not parse data production date '" + dateString + "' because it violates the following format: " + this.dateFormat.toPattern());
        }
    }

    protected static final class Index {
        private final boolean undefined;
        private final int index;

        Index(Properties properties, String key) {
            this(properties, key, 0);
        }

        Index(Properties properties, String key, int defaultValue) {
            this.undefined = StringUtils.isBlank((String)properties.getProperty(key));
            this.index = PropertyUtils.getInt(properties, key, defaultValue);
        }

        public final boolean isUndefined() {
            return this.undefined;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

