/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import org.apache.log4j.Logger;

public final class FileRenamer {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, FileRenamer.class);
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileRenamer.class);

    public static final boolean renameAndLog(File sourceFile, File destinationFile) {
        String absoluteTargetPath = destinationFile.getAbsolutePath();
        if (destinationFile.exists()) {
            notificationLog.error(String.format("Destination file '%s' already exists. Won't overwrite it.", absoluteTargetPath));
            return false;
        }
        boolean renamedOK = FileOperations.getMonitoredInstanceForCurrentThread().rename(sourceFile, destinationFile);
        if (renamedOK) {
            if (operationLog.isInfoEnabled()) {
                String entity = sourceFile.isDirectory() ? "directory" : "file";
                String name = sourceFile.getName();
                String parent = sourceFile.getParent();
                String path = destinationFile.getParent();
                operationLog.info(String.format("Moving %s '%s' from '%s' to '%s'.", entity, name, parent, path));
            }
            return true;
        }
        notificationLog.error(String.format("Moving '%s' to '%s' failed, giving up.", sourceFile.getAbsolutePath(), absoluteTargetPath));
        return false;
    }
}

