/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.PathPrefixPrepender;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.IFile;
import ch.systemsx.cisd.etlserver.IFileFactory;
import ch.systemsx.cisd.etlserver.IProcessor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProcessingInstructionDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

final class StandardProcessor
implements IProcessor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, StandardProcessor.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, StandardProcessor.class);
    private final IFileFactory fileFactory;
    private final PathPrefixPrepender pathPrefixPrepender;
    private final String parametersFileName;
    private final MessageFormat finishedFileFormat;
    private final StorageFormat inputDataFormat;
    private final String dataSetCodePrefixGlueCharacter;

    public StandardProcessor(IFileFactory fileFactory, StorageFormat inputDataFormat, PathPrefixPrepender pathPrefixPrepender, String parametersFileName, String finishedFileNameTemplate, String dataSetCodePrefixGlueCharacter) {
        assert (fileFactory != null) : "Unspecified IFileFactory.";
        assert (inputDataFormat != null) : "Unspecified StorageFormat.";
        assert (pathPrefixPrepender != null) : "Unspecified PathPrefixPrepender.";
        assert (parametersFileName != null) : "Unspecified parameters file name.";
        assert (finishedFileNameTemplate != null) : "Unspecified finished file name template.";
        assert (dataSetCodePrefixGlueCharacter != null) : "Unspecified data set code prefix glue character.";
        this.fileFactory = fileFactory;
        this.inputDataFormat = inputDataFormat;
        this.pathPrefixPrepender = pathPrefixPrepender;
        this.parametersFileName = parametersFileName;
        this.finishedFileFormat = new MessageFormat(finishedFileNameTemplate);
        this.dataSetCodePrefixGlueCharacter = dataSetCodePrefixGlueCharacter;
    }

    private void createDataSetForProcessing(File dataSet, IFile dataSetForProcessing) {
        StopWatch watch = new StopWatch();
        watch.start();
        dataSetForProcessing.copyFrom(dataSet);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Data set '" + dataSet.getName() + "' copied into '" + dataSetForProcessing.getAbsolutePath() + "', took " + watch + ".");
        }
    }

    private void createProcessingParameters(ProcessingInstructionDTO instruction, IFile processingDirectory, List<IFile> itemsToRemoveInCaseOfError) {
        byte[] instructionDataOrNull = instruction.getParameters();
        if (instructionDataOrNull != null) {
            IFile parametersFile = this.fileFactory.create(processingDirectory, this.parametersFileName);
            itemsToRemoveInCaseOfError.add(parametersFile);
            parametersFile.write(instructionDataOrNull);
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Processing parameters written into '" + parametersFile.getAbsolutePath() + "'.");
            }
        }
    }

    private void createFinishedFile(IFile processingDirectory, String dataSetName) {
        String finishedFileName = this.finishedFileFormat.format(new String[]{dataSetName});
        IFile finishedFile = this.fileFactory.create(processingDirectory, finishedFileName);
        finishedFile.write(new byte[0]);
    }

    private final String getDataSetName(DataSetInformation dataSetInformation, File dataSet) {
        String dataSetName = dataSet.getName();
        String parentDataSetCode = dataSetInformation.getDataSetCode();
        if (StringUtils.isNotEmpty((String)parentDataSetCode)) {
            return String.valueOf(parentDataSetCode) + this.dataSetCodePrefixGlueCharacter + dataSetName;
        }
        return dataSetName;
    }

    @Override
    public final StorageFormat getRequiredInputDataFormat() {
        return this.inputDataFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void initiateProcessing(ProcessingInstructionDTO instruction, DataSetInformation dataSetInformation, File dataSet) {
        block10: {
            if (!StandardProcessor.$assertionsDisabled && instruction == null) {
                throw new AssertionError((Object)"Unspecified instruction.");
            }
            if (!StandardProcessor.$assertionsDisabled && dataSet == null) {
                throw new AssertionError((Object)"Unspecified data set.");
            }
            if (!StandardProcessor.$assertionsDisabled && dataSetInformation == null) {
                throw new AssertionError((Object)"Unspecified data set information.");
            }
            if (StandardProcessor.operationLog.isInfoEnabled()) {
                StandardProcessor.operationLog.info("Start initialization of processing.");
            }
            processingPath = this.pathPrefixPrepender.addPrefixTo(instruction.getPath());
            processingDirectory = this.fileFactory.create(processingPath);
            processingDirectory.check();
            dataSetName = this.getDataSetName(dataSetInformation, dataSet);
            dataSetForProcessing = this.fileFactory.create(processingDirectory, dataSetName);
            itemsToRemoveInCaseOfError = new ArrayList<IFile>(2);
            itemsToRemoveInCaseOfError.add(dataSetForProcessing);
            try {
                InterruptedExceptionUnchecked.check();
                this.createDataSetForProcessing(dataSet, dataSetForProcessing);
                InterruptedExceptionUnchecked.check();
                this.createProcessingParameters(instruction, processingDirectory, itemsToRemoveInCaseOfError);
                InterruptedExceptionUnchecked.check();
                this.createFinishedFile(processingDirectory, dataSetName);
                if (StandardProcessor.operationLog.isInfoEnabled()) {
                    StandardProcessor.operationLog.info("Processing initiated.");
                }
                break block10;
            }
            catch (Exception ex) {
                ** for (item : itemsToRemoveInCaseOfError)
            }
lbl-1000:
            // 1 sources

            {
                item.delete();
                continue;
            }
lbl31:
            // 1 sources

            if (ex instanceof InterruptedExceptionUnchecked) {
                StandardProcessor.operationLog.warn(String.format("Requested to stop initiation of processing, rolled back: [data set: '%s'].", new Object[]{dataSetForProcessing.getAbsolutePath()}));
            } else {
                StandardProcessor.notificationLog.error(String.format("Error when initiating processing, rolled back: [data set: '%s'].", new Object[]{dataSetForProcessing.getAbsolutePath()}), ex);
            }
        }
    }
}

