/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.cifex;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.AbstractDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.cifex.CifexExtractorHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.DataSetUploadInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CifexDataSetInfoExtractor
implements IDataSetInfoExtractor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CifexDataSetInfoExtractor.class);
    @Private
    static final String DATA_SET_PROPERTIES_FILE_NAME_KEY = "data-set-properties-file-name";
    private final String dataSetPropertiesFileNameOrNull;

    public CifexDataSetInfoExtractor(Properties properties) {
        this.dataSetPropertiesFileNameOrNull = properties.getProperty(DATA_SET_PROPERTIES_FILE_NAME_KEY);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        assert (incomingDataSetPath != null) : "Incoming data set path can not be null.";
        DataSetUploadInfo info = CifexExtractorHelper.getDataSetUploadInfo(incomingDataSetPath);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Data set upload info: " + info);
        }
        DataSetInformation dataSetInformation = new DataSetInformation();
        SampleIdentifier sampleIdentifierOrNull = this.tryGetSampleIdentifier(info);
        if (sampleIdentifierOrNull != null) {
            dataSetInformation.setSampleCode(sampleIdentifierOrNull.getSampleCode());
            if (sampleIdentifierOrNull.isSpaceLevel()) {
                dataSetInformation.setSpaceCode(sampleIdentifierOrNull.getSpaceLevel().getSpaceCode());
            }
        } else {
            ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(info.getExperiment()).createIdentifier();
            dataSetInformation.setExperimentIdentifier(experimentIdentifier);
            dataSetInformation.setSpaceCode(experimentIdentifier.getSpaceCode());
            String[] parents = info.getParents() != null ? info.getParents() : new String[]{};
            dataSetInformation.setParentDataSetCodes(Arrays.asList(parents));
        }
        dataSetInformation.setUploadingUserEmail(CifexExtractorHelper.getUploadingUserEmail(incomingDataSetPath));
        dataSetInformation.setDataSetProperties(AbstractDataSetInfoExtractor.extractDataSetProperties(incomingDataSetPath, this.dataSetPropertiesFileNameOrNull));
        return dataSetInformation;
    }

    private SampleIdentifier tryGetSampleIdentifier(DataSetUploadInfo info) {
        return info.getSample() == null ? null : SampleIdentifierFactory.parse(info.getSample());
    }
}

