/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithm;
import ch.systemsx.cisd.etlserver.IExtensibleDataSetHandler;
import ch.systemsx.cisd.etlserver.entityregistration.AbstractSampleAndDataSetProcessor;
import ch.systemsx.cisd.etlserver.entityregistration.IRegistrationStatus;
import ch.systemsx.cisd.etlserver.entityregistration.RegistrationError;
import ch.systemsx.cisd.etlserver.entityregistration.RegistrationSuccess;
import ch.systemsx.cisd.etlserver.entityregistration.SampleAndDataSetControlFileProcessor;
import ch.systemsx.cisd.etlserver.entityregistration.SampleDataSetPair;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;

class SampleAndDataSetRegistrator
extends AbstractSampleAndDataSetProcessor
implements DataSetRegistrationAlgorithm.IDataSetInApplicationServerRegistrator {
    private final SampleAndDataSetControlFileProcessor.ControlFileRegistrationProperties properties;
    private final SampleDataSetPair sampleDataSetPair;
    private File dataSetFile;
    private Sample sampleOrNull;
    private boolean didSucceed = false;
    private IRegistrationStatus failureException = null;

    SampleAndDataSetRegistrator(File folder, SampleAndDataSetControlFileProcessor.ControlFileRegistrationProperties properties, SampleDataSetPair sampleDataSetPair) {
        super(properties.getGlobalProperties(), folder);
        this.properties = properties;
        this.sampleDataSetPair = sampleDataSetPair;
    }

    public IRegistrationStatus register() {
        this.dataSetFile = new File(this.folder, this.sampleDataSetPair.getFolderName());
        try {
            this.checkDataSetFileNotEmpty();
            this.checkExperimentExists();
            this.retrieveSampleOrNull();
        }
        catch (UserFailureException ex) {
            this.sampleDataSetPair.setProcessingApplied(SampleDataSetPair.SampleDataSetPairProcessing.FAILED);
            return new RegistrationError(ex);
        }
        try {
            this.checkConformanceToMode();
        }
        catch (UserFailureException ex) {
            this.sampleDataSetPair.setProcessingApplied(SampleDataSetPair.SampleDataSetPairProcessing.SKIPPED);
            return new RegistrationError(ex);
        }
        if (this.globalState.getDelegator() instanceof IExtensibleDataSetHandler) {
            IExtensibleDataSetHandler handler = (IExtensibleDataSetHandler)this.globalState.getDelegator();
            handler.handleDataSet(this.dataSetFile, this.sampleDataSetPair.getDataSetInformation(), this);
            if (this.didSucceed) {
                this.logDataRegistered();
                if (this.isSampleKnown()) {
                    this.sampleDataSetPair.setProcessingApplied(SampleDataSetPair.SampleDataSetPairProcessing.UPDATED_SAMPLE_REGISTERED_DATA_SET);
                } else {
                    this.sampleDataSetPair.setProcessingApplied(SampleDataSetPair.SampleDataSetPairProcessing.REGISTERED_SAMPLE_AND_DATA_SET);
                }
            }
        }
        if (this.failureException == null) {
            return new RegistrationSuccess(this.sampleDataSetPair.getTokens());
        }
        this.sampleDataSetPair.setProcessingApplied(SampleDataSetPair.SampleDataSetPairProcessing.FAILED);
        return this.failureException;
    }

    public File getDataSetFile() {
        return this.dataSetFile;
    }

    private void checkConformanceToMode() {
        switch (this.globalState.getSampleRegistrationMode()) {
            case IGNORE_EXISTING: {
                if (!this.isSampleKnown()) break;
                throw new UserFailureException("This sample has already been registered.");
            }
            case REJECT_NONEXISTING: {
                if (this.isSampleKnown()) break;
                throw new UserFailureException("This drop box expects existing samples. This sample does not exist.");
            }
        }
    }

    private void checkDataSetFileNotEmpty() {
        if (this.dataSetFile.list().length == 0) {
            throw new UserFailureException("The data set folder cannot be empty");
        }
    }

    private void retrieveSampleOrNull() {
        String sampleIdString = this.sampleDataSetPair.getNewSample().getIdentifier();
        if (sampleIdString == null) {
            throw new UserFailureException("A sample identifier must be specified");
        }
        SampleIdentifier sampleIdentifier = new SampleIdentifierFactory(sampleIdString).createIdentifier();
        if (sampleIdentifier == null) {
            throw new UserFailureException("The sample identifier does not conform to the sample identifier format");
        }
        this.sampleOrNull = this.globalState.getOpenbisService().tryGetSampleWithExperiment(sampleIdentifier);
    }

    private void checkExperimentExists() {
        ExperimentIdentifier experimentId = this.sampleDataSetPair.getDataSetInformation().getExperimentIdentifier();
        if (experimentId == null) {
            throw new UserFailureException("An experiment identifier must be specified");
        }
        Experiment experiment = this.globalState.getOpenbisService().tryGetExperiment(experimentId);
        if (experiment == null) {
            throw new UserFailureException("The experiment with identifier " + experimentId + " does not exist");
        }
        this.sampleDataSetPair.getDataSetInformation().setExperiment(experiment);
    }

    private void logDataRegistered() {
        String messageFormat = this.isSampleKnown() ? "Updated sample, registered data set %s" : "Registered sample/data set pair %s";
        String message = String.format(messageFormat, this.sampleDataSetPair);
        this.logInfo(message);
    }

    @Override
    public void registerDataSetInApplicationServer(NewExternalData data) throws Throwable {
        this.syncDataToDataSetProperties(data);
        try {
            Sample sample = this.isSampleKnown() ? this.globalState.getOpenbisService().updateSampleAndRegisterDataSet(this.sampleDataSetPair.getSampleUpdates(this.sampleOrNull), data) : this.globalState.getOpenbisService().registerSampleAndDataSet(this.sampleDataSetPair.getNewSample(), data, this.properties.getUser().getUserId());
            DataSetInformation dataSetInformation = this.sampleDataSetPair.getDataSetInformation();
            dataSetInformation.setSampleCode(sample.getCode());
            dataSetInformation.setSample(sample);
            this.didSucceed = true;
        }
        catch (UserFailureException e) {
            this.didSucceed = false;
            this.failureException = new RegistrationError(e);
            throw e;
        }
        catch (Throwable e) {
            this.logError("Could not register " + this.sampleDataSetPair + " in openBIS", e);
            this.didSucceed = false;
            this.failureException = new RegistrationError(e);
            throw e;
        }
    }

    private void syncDataToDataSetProperties(NewExternalData data) {
        data.setDataSetType(this.properties.getDataSetType());
        if (this.sampleDataSetPair.getFileFormatTypeCode() != null) {
            FileFormatType fileFormatType = new FileFormatType(this.sampleDataSetPair.getFileFormatTypeCode());
            data.setFileFormatType(fileFormatType);
        }
    }

    private boolean isSampleKnown() {
        return this.sampleOrNull != null;
    }
}

