/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.etlserver.IDataSetPathsInfoFeeder;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.path.PathEntryDTO;
import ch.systemsx.cisd.etlserver.path.PathInfo;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DatabaseBasedDataSetPathsInfoFeeder
implements IDataSetPathsInfoFeeder {
    private static final int BATCH_SIZE = 500;
    private final IPathsInfoDAO dao;
    private final IHierarchicalContentFactory hierarchicalContentFactory;
    private final List<PathEntryDTO> filePaths = new ArrayList<PathEntryDTO>(500);
    private final boolean computeChecksum;

    public DatabaseBasedDataSetPathsInfoFeeder(IPathsInfoDAO dao, IHierarchicalContentFactory hierarchicalContentFactory, boolean computeChecksum) {
        this.dao = dao;
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.computeChecksum = computeChecksum;
    }

    @Override
    public long addPaths(String dataSetCode, String location, File dataSetRoot) {
        long dataSetId = this.dao.createDataSet(dataSetCode, location);
        IHierarchicalContent content = this.hierarchicalContentFactory.asHierarchicalContent(dataSetRoot, IDelegatedAction.DO_NOTHING);
        PathInfo root = PathInfo.createPathInfo(this.hierarchicalContentFactory.asHierarchicalContentNode(content, dataSetRoot), this.computeChecksum);
        this.addPaths(dataSetId, null, "", root);
        return root.getSizeInBytes();
    }

    private void addPaths(long dataSetId, Long parentId, String pathPrefix, PathInfo pathInfo) {
        String relativePath;
        boolean directory = pathInfo.isDirectory();
        String fileName = pathInfo.getFileName();
        String string = relativePath = parentId == null ? "" : String.valueOf(pathPrefix) + fileName;
        if (directory) {
            long directoryId = this.dao.createDataSetFile(dataSetId, parentId, relativePath, fileName, pathInfo.getSizeInBytes(), directory, pathInfo.getLastModifiedDate());
            if (relativePath.length() > 0) {
                relativePath = String.valueOf(relativePath) + '/';
            }
            List<PathInfo> children = pathInfo.getChildren();
            for (PathInfo child : children) {
                this.addPaths(dataSetId, directoryId, relativePath, child);
            }
        } else {
            this.addFilePathToBatch(new PathEntryDTO(dataSetId, parentId, relativePath, fileName, pathInfo.getSizeInBytes(), pathInfo.getChecksumCRC32(), false, pathInfo.getLastModifiedDate()));
        }
    }

    private void addFilePathToBatch(PathEntryDTO filePath) {
        this.filePaths.add(filePath);
        if (this.filePaths.size() == 500) {
            this.dao.createDataSetFiles(this.filePaths);
            this.filePaths.clear();
        }
    }

    @Override
    public void commit() {
        if (!this.filePaths.isEmpty()) {
            this.dao.createDataSetFiles(this.filePaths);
            this.filePaths.clear();
        }
        this.dao.commit();
    }
}

