/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.etlserver.path.PathEntryDTO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TransactionQuery;
import net.lemnik.eodsql.Update;

public interface IPathsInfoDAO
extends TransactionQuery {
    @Select(value="select id from data_sets where code = ?{1}")
    public Long tryGetDataSetId(String var1);

    @Select(value="insert into data_sets (code, location) values (?{1}, ?{2}) returning id")
    public long createDataSet(String var1, String var2);

    @Select(value="insert into data_set_files (dase_id, parent_id, relative_path, file_name, size_in_bytes, is_directory, last_modified) values (?{1}, ?{2}, ?{3}, ?{4}, ?{5}, ?{6}, ?{7}) returning id")
    public long createDataSetFile(long var1, Long var3, String var4, String var5, long var6, boolean var8, Date var9);

    @Select(value="select registration_timestamp from last_feeding_event")
    public Date getRegistrationTimestampOfLastFeedingEvent();

    @Update(value="delete from last_feeding_event")
    public void deleteLastFeedingEvent();

    @Update(value="insert into last_feeding_event (registration_timestamp) values (?{1})")
    public void createLastFeedingEvent(Date var1);

    @Update(sql="insert into data_set_files (dase_id, parent_id, relative_path, file_name, size_in_bytes, checksum_crc32, is_directory, last_modified) values (?{1.dataSetId}, ?{1.parentId}, ?{1.relativePath}, ?{1.fileName}, ?{1.sizeInBytes}, ?{1.checksumCRC32}, ?{1.directory}, ?{1.lastModifiedDate})", batchUpdate=true)
    public void createDataSetFiles(Collection<PathEntryDTO> var1);

    @Select(value="select f.id, d.code as data_set_code, relative_path from data_set_files as f join data_sets as d on f.dase_id = d.id where checksum_crc32 is null and is_directory = 'F'")
    public List<PathEntryDTO> listDataSetFilesWithUnkownChecksum();

    @Update(value="update data_set_files set checksum_crc32 = ?{2} where id = ?{1}")
    public void updateChecksum(long var1, int var3);

    @Select(sql="select d.code as data_set_code, size_in_bytes from data_set_files as f join data_sets as d on f.dase_id = d.id where d.code = any(?{1}) and parent_id is null", parameterBindings={StringArrayMapper.class})
    public List<PathEntryDTO> listDataSetsSize(String[] var1);
}

