/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.SoftLinkMaker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.plugins.IHierarchicalStorageLinkNamingStrategy;
import ch.systemsx.cisd.etlserver.plugins.TemplateBasedLinkNamingStrategy;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HierarchicalStorageUpdater
implements IDataStoreLockingMaintenanceTask {
    public static final String STOREROOT_DIR_KEY = "storeroot-dir";
    public static final String HIERARCHY_ROOT_DIR_KEY = "hierarchy-root-dir";
    public static final String HIERARCHY_LINK_NAMING_STRATEGY = "link-naming-strategy";
    public static final String LINK_SOURCE_SUBFOLDER = "link-source-subpath";
    public static final String LINK_FROM_FIRST_CHILD = "link-from-first-child";
    private static final String REBUILDING_HIERARCHICAL_STORAGE = "Rebuilding hierarchical storage";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HierarchicalStorageUpdater.class);
    private IEncapsulatedOpenBISService openBISService;
    private IHierarchicalStorageLinkNamingStrategy linkNamingStrategy;
    private File storeRoot;
    private File hierarchyRoot;
    private Map<String, LinkSourceDescriptor> linkSourceDescriptors;

    @Override
    public void setUp(String pluginName, Properties pluginProperties) {
        LogInitializer.init();
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        String storeRootFileName = PropertyUtils.getMandatoryProperty(properties, STOREROOT_DIR_KEY);
        String hierarchyRootFileName = PropertyUtils.getMandatoryProperty(properties, String.valueOf(pluginName) + "." + HIERARCHY_ROOT_DIR_KEY);
        this.openBISService = ServiceProvider.getOpenBISService();
        this.linkNamingStrategy = this.createLinkNamingStrategy(pluginProperties);
        this.storeRoot = new File(storeRootFileName);
        this.hierarchyRoot = new File(hierarchyRootFileName);
        this.linkSourceDescriptors = this.initializeLinkSourceDescriptors(pluginProperties);
        operationLog.info("Plugin initialized with: store root = " + storeRootFileName + ", hierarchy root = " + hierarchyRootFileName);
    }

    @Override
    public void execute() {
        this.rebuildHierarchy();
    }

    @Override
    public boolean requiresDataStoreLock() {
        return true;
    }

    private IHierarchicalStorageLinkNamingStrategy createLinkNamingStrategy(Properties properties) {
        String linkNamingStrategyClassName = PropertyUtils.getProperty(properties, HIERARCHY_LINK_NAMING_STRATEGY, TemplateBasedLinkNamingStrategy.class.getName());
        ExtendedProperties strategyProperties = ExtendedProperties.getSubset(properties, "link-naming-strategy.", true);
        try {
            return ClassUtils.create(IHierarchicalStorageLinkNamingStrategy.class, Class.forName(linkNamingStrategyClassName), strategyProperties);
        }
        catch (ClassNotFoundException ex) {
            throw ConfigurationFailureException.fromTemplate("Wrong '%s' property: %s", HIERARCHY_LINK_NAMING_STRATEGY, ex.getMessage());
        }
    }

    private Map<String, LinkSourceDescriptor> initializeLinkSourceDescriptors(Properties pluginProperties) {
        HashMap<String, LinkSourceDescriptor> result = new HashMap<String, LinkSourceDescriptor>();
        ExtendedProperties subFolderProps = ExtendedProperties.getSubset(pluginProperties, "link-source-subpath.", true);
        ExtendedProperties linkFromFirstChildProps = ExtendedProperties.getSubset(pluginProperties, "link-from-first-child.", true);
        HashSet<Object> dataSetTypes = new HashSet<Object>();
        dataSetTypes.addAll(subFolderProps.keySet());
        dataSetTypes.addAll(linkFromFirstChildProps.keySet());
        for (Object e : dataSetTypes) {
            String dataSetType = (String)e;
            String subFolder = subFolderProps.getProperty(dataSetType);
            boolean linkFromFirstChild = Boolean.parseBoolean(linkFromFirstChildProps.getProperty(dataSetType));
            LinkSourceDescriptor descriptor = new LinkSourceDescriptor(subFolder, linkFromFirstChild);
            result.put(dataSetType, descriptor);
        }
        return result;
    }

    private void rebuildHierarchy() {
        operationLog.info(REBUILDING_HIERARCHICAL_STORAGE);
        Map<String, String> newLinkMappings = this.convertDataToLinkMappings();
        HashSet<String> toCreate = new HashSet<String>(newLinkMappings.keySet());
        Set<String> toDelete = this.linkNamingStrategy.extractPaths(this.hierarchyRoot);
        Set<String> dontTouch = this.intersection(toCreate, toDelete);
        toCreate.removeAll(dontTouch);
        toDelete.removeAll(dontTouch);
        this.removeUnnecessaryMappings(newLinkMappings, toCreate);
        this.deleteObsoleteLinks(toDelete);
        this.createLinksForChangedData(newLinkMappings);
    }

    private Map<String, String> convertDataToLinkMappings() {
        List<SimpleDataSetInformationDTO> dataSets = this.openBISService.listPhysicalDataSets();
        HashMap<String, String> linkMappings = new HashMap<String, String>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            File targetFile = new File(this.hierarchyRoot, this.linkNamingStrategy.createHierarchicalPath(dataSet));
            File share = new File(this.storeRoot, dataSet.getDataSetShareId());
            File dataSetLocationRoot = new File(share, dataSet.getDataSetLocation());
            File linkSource = this.determineLinkSource(dataSetLocationRoot, dataSet.getDataSetType());
            if (linkSource != null) {
                linkMappings.put(targetFile.getAbsolutePath(), linkSource.getAbsolutePath());
                continue;
            }
            String logMessage = String.format("Can not determine the link source file for data set '%s', dataSetType='%s'. Link creation will be skipped.", dataSetLocationRoot, dataSet.getDataSetType());
            operationLog.warn(logMessage);
        }
        return linkMappings;
    }

    private File determineLinkSource(File dataSetLocationRoot, String dataSetType) {
        LinkSourceDescriptor linkSourceDescriptor = this.getLinkSourceDescriptor(dataSetType);
        File source = dataSetLocationRoot;
        if (linkSourceDescriptor != null) {
            String subPath = linkSourceDescriptor.getSubFolder();
            if (!StringUtils.isBlank((String)subPath) && !(source = new File(String.valueOf(source.getAbsolutePath()) + File.separator + subPath)).exists()) {
                String logMessage = String.format("Invalid '%s' configuration for data set '%s'. Subfolder '%s' does not exist", LINK_SOURCE_SUBFOLDER, dataSetLocationRoot, source);
                operationLog.warn(logMessage);
                return null;
            }
            if (linkSourceDescriptor.isLinkFromFirstChild() && source.isDirectory()) {
                File[] rootChildren = source.listFiles();
                if (rootChildren == null || rootChildren.length == 0) {
                    String logMessage = String.format("Invalid '%s' configuration for data set '%s'. Subfolder '%s' has no children", LINK_FROM_FIRST_CHILD, dataSetLocationRoot, source);
                    operationLog.warn(logMessage);
                    return null;
                }
                source = rootChildren[0];
            }
        }
        return source;
    }

    private LinkSourceDescriptor getLinkSourceDescriptor(String dataSetType) {
        return this.linkSourceDescriptors.get(dataSetType);
    }

    private void removeUnnecessaryMappings(Map<String, String> linkMappings, Set<String> keep) {
        HashSet<String> keys = new HashSet<String>(linkMappings.keySet());
        for (String path : keys) {
            if (keep.contains(path)) continue;
            linkMappings.remove(path);
        }
    }

    private Set<String> intersection(Set<String> setA, Set<String> setB) {
        HashSet<String> toBeUntouched = new HashSet<String>(setA);
        toBeUntouched.retainAll(setB);
        return toBeUntouched;
    }

    private void deleteObsoleteLinks(Set<String> toBeDeleted) {
        block0: for (String pathToDelete : toBeDeleted) {
            File toDelete = new File(pathToDelete);
            File parent = toDelete.getParentFile();
            this.deleteWithSymbolicLinks(toDelete);
            while (parent != null && !this.isSameFile(parent, this.hierarchyRoot)) {
                if (parent.list().length != 0) continue block0;
                toDelete = parent;
                parent = toDelete.getParentFile();
                this.delete(toDelete);
            }
        }
    }

    private boolean isSameFile(File file1, File file2) {
        try {
            return file1.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException ioex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ioex);
        }
    }

    private void deleteWithSymbolicLinks(File toDelete) {
        if (toDelete.isDirectory()) {
            File[] fileArray = toDelete.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean ok = this.delete(file);
                if (!ok) {
                    operationLog.error("Cannot delete the file: " + file.getPath());
                }
                ++n2;
            }
        }
        this.delete(toDelete);
    }

    private boolean delete(File file) {
        if (this.canBeDeleted(file)) {
            operationLog.info("Deleting " + file.getAbsolutePath());
            return file.delete();
        }
        operationLog.error(String.valueOf(file.getPath()) + " is not a symbolic link and will not be deleted.");
        return false;
    }

    private boolean canBeDeleted(File file) {
        if (this.isUnderHierarchyRoot(file)) {
            return FileUtilities.isSymbolicLink(file) || file.isDirectory();
        }
        operationLog.warn("Aborting an attempt to delete content outside of hierarchy root : " + file.getAbsolutePath() + ". Please analyze, this is a programming error.");
        return false;
    }

    private boolean isUnderHierarchyRoot(File file) {
        return file.getAbsolutePath().startsWith(this.hierarchyRoot.getAbsolutePath());
    }

    private void createLinksForChangedData(Map<String, String> linkMappings) {
        for (String targetPath : linkMappings.keySet()) {
            File targetDir = new File(targetPath);
            String sourcePath = linkMappings.get(targetPath);
            File sourceFile = new File(sourcePath);
            targetDir.getParentFile().mkdirs();
            SoftLinkMaker.createSymbolicLink(sourceFile, targetDir);
        }
    }

    private static class LinkSourceDescriptor {
        private final String subFolder;
        private final boolean linkFromFirstChild;

        public LinkSourceDescriptor(String subFolder, boolean linkFromFirstChild) {
            this.subFolder = subFolder;
            this.linkFromFirstChild = linkFromFirstChild;
        }

        public String getSubFolder() {
            return this.subFolder;
        }

        public boolean isLinkFromFirstChild() {
            return this.linkFromFirstChild;
        }
    }
}

