/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.etlserver.plugins.DirectoryAction;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class MonitoredDirectory {
    private final File directory;
    private final String readyToImportMarkerFile;
    private final String alreadyImportedMarkerFile;

    public MonitoredDirectory(File directory, String readyToImportMarkerFile, String alreadyImportedMarkerFile) {
        if (directory.isFile()) {
            throw new IllegalArgumentException("Monitored directory " + directory.getAbsolutePath() + " is a file.");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Monitored directory " + directory.getAbsolutePath() + " does not exist.");
        }
        if (!directory.canWrite()) {
            throw new IllegalArgumentException("Cannot write to monitored directory " + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("Cannot read from monitored directory " + directory.getAbsolutePath());
        }
        if (readyToImportMarkerFile.equals(alreadyImportedMarkerFile)) {
            throw new IllegalArgumentException("Cannot have same value for both marker files (" + readyToImportMarkerFile + ")");
        }
        this.directory = directory;
        this.readyToImportMarkerFile = readyToImportMarkerFile;
        this.alreadyImportedMarkerFile = alreadyImportedMarkerFile;
    }

    public void perform(DirectoryAction action) {
        for (File subdir : this.listSubDirectoriesOf(this.directory)) {
            File ready = new File(subdir, this.readyToImportMarkerFile);
            File imported = new File(subdir, this.alreadyImportedMarkerFile);
            if (!ready.exists() || imported.exists()) continue;
            try {
                imported.createNewFile();
                action.performOn(subdir);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Collection<File> listSubDirectoriesOf(File dir) {
        File[] subdirectories = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return Arrays.asList(subdirectories);
    }
}

