/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTaskForPhysicalDataSets;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.HierarchicalStructureDuplicatorFileToHDF5;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class Hdf5CompressingPostRegistrationTask
extends AbstractPostRegistrationTaskForPhysicalDataSets {
    public static final String DATA_SET_TYPES = "data-set-types";
    private static final String HDF5_COMPRESSION_CLEANUP_MARKERS_DIRNAME = "hdf5-cleanup-markers";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Hdf5CompressingPostRegistrationTask.class);
    private final Set<String> processedDataSetTypes;

    public Hdf5CompressingPostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service) {
        super(properties, service);
        this.processedDataSetTypes = new HashSet<String>(PropertyUtils.tryGetList(properties, DATA_SET_TYPES));
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode) {
        return new Executor(dataSetCode);
    }

    static AbstractExternalData tryGetDataSet(String dataSetCode, IEncapsulatedOpenBISService service) {
        List<String> codeAsList = Collections.singletonList(dataSetCode);
        List<AbstractExternalData> dataList = service.listDataSetsByCode(codeAsList);
        if (dataList == null || dataList.isEmpty()) {
            return null;
        }
        return dataList.get(0);
    }

    private ExperimentIdentifier extractExperimentIdentifier(AbstractExternalData data) {
        return ExperimentIdentifierFactory.parse(data.getExperiment().getIdentifier());
    }

    private SampleIdentifier extractSampleIdentifier(AbstractExternalData data) {
        if (data.getSampleIdentifier() != null) {
            return SampleIdentifierFactory.parse(data.getSampleIdentifier());
        }
        return null;
    }

    private static File getCleanupMarkerFile(String dataSetCode, String shareId) {
        File storeRoot = ServiceProvider.getConfigProvider().getStoreRoot();
        File shareRoot = new File(storeRoot, shareId);
        File hdf5CompressionMarkers = new File(shareRoot, HDF5_COMPRESSION_CLEANUP_MARKERS_DIRNAME);
        return new File(hdf5CompressionMarkers, dataSetCode);
    }

    protected class Executor
    implements IPostRegistrationTaskExecutor {
        protected final String dataSetCode;

        protected Executor(String dataSetCode) {
            this.dataSetCode = dataSetCode;
        }

        protected void notifyTwinDataSetCreated(String hdf5DataSetCode) {
        }

        @Override
        public void execute() {
            AbstractExternalData externalData = Hdf5CompressingPostRegistrationTask.tryGetDataSet(this.dataSetCode, Hdf5CompressingPostRegistrationTask.this.service);
            if (!this.shouldCompressToHdf5(externalData)) {
                return;
            }
            IHierarchicalContent hierarchicalContent = this.tryGetHierarchicalContent(externalData);
            if (hierarchicalContent == null) {
                return;
            }
            try {
                if (!this.hasFoldersForCompressing(hierarchicalContent)) {
                    if (!this.hasCompressedFiles(hierarchicalContent)) {
                        operationLog.info(String.format(" Data set '%s' meets the criterion for HDF5 compression in post registration, but it contains no folder named '*.h5'. HDF5 compression will be skipped...", this.dataSetCode));
                    }
                    return;
                }
                String hdf5DataSetCode = Hdf5CompressingPostRegistrationTask.this.service.createPermId();
                operationLog.info(String.format("The contents of data set '%s' will be hdf5-compressed into a new data set '%s'.", this.dataSetCode, hdf5DataSetCode));
                PhysicalDataSet dataSet = (PhysicalDataSet)externalData;
                File hdf5DataSetDir = this.createNewDataSetDirectory(hierarchicalContent, hdf5DataSetCode);
                File cleanupMarker = this.createCleanupMarker(dataSet.getShareId(), hdf5DataSetDir);
                this.createCompressedDuplicate(hdf5DataSetDir, hierarchicalContent);
                this.registerTwinDataset(hdf5DataSetCode, dataSet);
                this.notifyTwinDataSetCreated(hdf5DataSetCode);
                this.removeOldDataSet(this.dataSetCode, "Replaced by '" + hdf5DataSetCode + "'");
                cleanupMarker.delete();
                operationLog.info(String.format("Data set '%s' is now replaced by its hdf5-compressed counterpart '%s'.", this.dataSetCode, hdf5DataSetCode));
            }
            finally {
                hierarchicalContent.close();
            }
        }

        private IHierarchicalContent tryGetHierarchicalContent(AbstractExternalData externalData) {
            try {
                return ServiceProvider.getHierarchicalContentProvider().asContent(externalData);
            }
            catch (IllegalArgumentException iae) {
                operationLog.error("Cannot get hierarchical content for external data " + externalData, iae);
                return null;
            }
        }

        private File createCleanupMarker(String shareId, File hdf5DataSetDir) {
            File markerFile = Hdf5CompressingPostRegistrationTask.getCleanupMarkerFile(this.dataSetCode, shareId);
            File markerDir = markerFile.getParentFile();
            markerDir.mkdirs();
            if (!markerDir.exists()) {
                throw new EnvironmentFailureException("Cannot created HDF5 compression marker directory ");
            }
            FileUtilities.writeToFile(markerFile, hdf5DataSetDir.getAbsolutePath());
            return markerFile;
        }

        private void removeOldDataSet(String dataSetToDelete, String reason) {
            Hdf5CompressingPostRegistrationTask.this.service.removeDataSetsPermanently(Collections.singletonList(dataSetToDelete), reason);
        }

        private void createCompressedDuplicate(File stagingDir, IHierarchicalContent hierarchicalContent) {
            IHierarchicalContentNode root = hierarchicalContent.getRootNode();
            for (IHierarchicalContentNode child : root.getChildNodes()) {
                File fileOrFolder = child.getFile();
                if (this.shouldBeCompressed(fileOrFolder)) {
                    File h5ContainerFile = new File(stagingDir, fileOrFolder.getName());
                    HDF5Container container = new HDF5Container(h5ContainerFile);
                    container.runWriterClient(true, new HierarchicalStructureDuplicatorFileToHDF5.DuplicatorWriterClient(fileOrFolder));
                    continue;
                }
                this.copy(fileOrFolder, stagingDir);
            }
        }

        private void copy(File fileOrFolder, File toDir) {
            try {
                if (fileOrFolder.isFile()) {
                    FileUtils.copyFileToDirectory((File)fileOrFolder, (File)toDir);
                } else {
                    FileUtils.copyDirectoryToDirectory((File)fileOrFolder, (File)toDir);
                }
            }
            catch (IOException ioex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ioex);
            }
        }

        private File createNewDataSetDirectory(IHierarchicalContent hierarchicalContent, String hdf5DataSetCode) {
            File existingDataSetRoot = hierarchicalContent.getRootNode().getFile();
            File newDataSetRoot = new File(existingDataSetRoot.getParent(), hdf5DataSetCode);
            if (!newDataSetRoot.mkdirs()) {
                throw new EnvironmentFailureException("Cannot create folder for HDF5 compression data set - '" + newDataSetRoot + "'");
            }
            return newDataSetRoot;
        }

        private boolean shouldBeCompressed(File file) {
            return file.isDirectory() && FileUtilities.hasHDF5ContainerSuffix(file);
        }

        private boolean hasFoldersForCompressing(IHierarchicalContent hierarchicalContent) {
            IHierarchicalContentNode root = hierarchicalContent.getRootNode();
            for (IHierarchicalContentNode child : root.getChildNodes()) {
                if (!this.shouldBeCompressed(child.getFile())) continue;
                return true;
            }
            return false;
        }

        private boolean hasCompressedFiles(IHierarchicalContent hierarchicalContent) {
            IHierarchicalContentNode root = hierarchicalContent.getRootNode();
            for (IHierarchicalContentNode child : root.getChildNodes()) {
                if (!FileUtilities.isHDF5ContainerFile(child.getFile())) continue;
                return true;
            }
            return false;
        }

        private boolean shouldCompressToHdf5(AbstractExternalData dataSet) {
            if (dataSet == null) {
                operationLog.warn("Data set '" + this.dataSetCode + "' is no longer available in openBIS." + "Archiving post-registration task will be skipped...");
                return false;
            }
            if (dataSet.tryGetContainer() == null) {
                operationLog.info("Data set '" + this.dataSetCode + "' is not part of a container." + "Compression to HDF5 will be skipped...");
                return false;
            }
            String dataSetTypeCode = dataSet.getDataSetType().getCode();
            if (!Hdf5CompressingPostRegistrationTask.this.processedDataSetTypes.contains(dataSetTypeCode)) {
                operationLog.debug(String.format("Data set type '%s' is not configured for HDF5 compressing. Skipping compression for data set '%s'...", dataSetTypeCode, this.dataSetCode));
                return false;
            }
            return true;
        }

        @Override
        public ICleanupTask createCleanupTask() {
            return new Hdf5CompressingCleanupTask(this.dataSetCode);
        }

        private void registerTwinDataset(String hdf5DataSetCode, PhysicalDataSet protoDataSet) {
            DataSetInformation dataSetInformation = this.createDataSetInformation(protoDataSet);
            NewExternalData twinExternalData = this.createTwin(hdf5DataSetCode, protoDataSet);
            Hdf5CompressingPostRegistrationTask.this.service.registerDataSet(dataSetInformation, twinExternalData);
            ContainerDataSet container = protoDataSet.tryGetContainer();
            DataSetUpdatesDTO containerUpdate = this.addNewContainedDataSet(container, hdf5DataSetCode);
            Hdf5CompressingPostRegistrationTask.this.service.updateDataSet(containerUpdate);
        }

        private DataSetInformation createDataSetInformation(PhysicalDataSet protoDataSet) {
            DataSetInformation result = new DataSetInformation();
            result.setExperimentIdentifier(Hdf5CompressingPostRegistrationTask.this.extractExperimentIdentifier(protoDataSet));
            SampleIdentifier sampleIdentifier = Hdf5CompressingPostRegistrationTask.this.extractSampleIdentifier(protoDataSet);
            if (sampleIdentifier != null) {
                result.setSampleIdentifier(sampleIdentifier);
            }
            return result;
        }

        private DataSetUpdatesDTO addNewContainedDataSet(ContainerDataSet container, String hdf5DataSetCode) {
            DataSetUpdatesDTO updatesDTO = new DataSetUpdatesDTO();
            updatesDTO.setVersion(container.getVersion());
            updatesDTO.setDatasetId(new TechId(container.getId()));
            updatesDTO.setProperties(container.getProperties());
            updatesDTO.setExperimentIdentifierOrNull(Hdf5CompressingPostRegistrationTask.this.extractExperimentIdentifier(container));
            updatesDTO.setSampleIdentifierOrNull(Hdf5CompressingPostRegistrationTask.this.extractSampleIdentifier(container));
            List<String> newContainedCodes = Code.extractCodes(container.getContainedDataSets());
            int hdf5DataSetIndex = Math.max(0, newContainedCodes.indexOf(this.dataSetCode));
            newContainedCodes.add(hdf5DataSetIndex, hdf5DataSetCode);
            updatesDTO.setModifiedContainedDatasetCodesOrNull(newContainedCodes.toArray(new String[0]));
            return updatesDTO;
        }

        private NewExternalData createTwin(String hdf5DataSetCode, PhysicalDataSet protoDataSet) {
            NewExternalData externalData = new NewExternalData();
            externalData.setDataProducerCode(protoDataSet.getDataProducerCode());
            externalData.setDataSetProperties(this.extractProperties(protoDataSet));
            externalData.setDataSetType(protoDataSet.getDataSetType());
            externalData.setDataStoreCode(protoDataSet.getDataStore().getCode());
            externalData.setExperimentIdentifierOrNull(Hdf5CompressingPostRegistrationTask.this.extractExperimentIdentifier(protoDataSet));
            externalData.setMeasured(!protoDataSet.isDerived());
            externalData.setParentDataSetCodes(Code.extractCodes(protoDataSet.getParents()));
            externalData.setProductionDate(protoDataSet.getProductionDate());
            externalData.setRegistrationDate(protoDataSet.getRegistrationDate());
            externalData.setSampleIdentifierOrNull(Hdf5CompressingPostRegistrationTask.this.extractSampleIdentifier(protoDataSet));
            externalData.setFileFormatType(protoDataSet.getFileFormatType());
            externalData.setLocation(protoDataSet.getLocation());
            externalData.setLocatorType(protoDataSet.getLocatorType());
            externalData.setShareId(protoDataSet.getShareId());
            externalData.setSpeedHint(protoDataSet.getSpeedHint());
            externalData.setStorageFormat(StorageFormat.PROPRIETARY);
            externalData.setCode(hdf5DataSetCode);
            File protoDataSetLocation = new File(protoDataSet.getLocation());
            String newDataSetLocation = new File(protoDataSetLocation.getParentFile(), hdf5DataSetCode).getPath();
            externalData.setLocation(newDataSetLocation);
            return externalData;
        }

        private List<NewProperty> extractProperties(PhysicalDataSet protoDataSet) {
            ArrayList<NewProperty> newProperties = new ArrayList<NewProperty>();
            for (IEntityProperty prop : protoDataSet.getProperties()) {
                NewProperty newProp = new NewProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
                newProperties.add(newProp);
            }
            return newProperties;
        }
    }

    private static class Hdf5CompressingCleanupTask
    implements ICleanupTask {
        private static final long serialVersionUID = 1L;
        private final String dataSetCode;

        Hdf5CompressingCleanupTask(String dataSetCode) {
            this.dataSetCode = dataSetCode;
        }

        @Override
        public void cleanup(ISimpleLogger logger) {
            File cleanupMarkerFile;
            PhysicalDataSet dataSet = (PhysicalDataSet)Hdf5CompressingPostRegistrationTask.tryGetDataSet(this.dataSetCode, ServiceProvider.getOpenBISService());
            if (dataSet != null && (cleanupMarkerFile = Hdf5CompressingPostRegistrationTask.getCleanupMarkerFile(this.dataSetCode, dataSet.getShareId())).exists()) {
                this.cleanup(dataSet, cleanupMarkerFile);
                cleanupMarkerFile.delete();
            }
        }

        private void cleanup(PhysicalDataSet dataSet, File cleanupMarkerFile) {
            String danglingHdf5DirName = FileUtilities.loadToString(cleanupMarkerFile).trim();
            File danglingDataSetDir = new File(danglingHdf5DirName);
            if (danglingDataSetDir.exists()) {
                Collection<String> danglingDirContents = this.getDanglingDirContentsAsSet(danglingDataSetDir);
                Collection<String> dataSetContents = this.getDataSetContents(dataSet);
                if (dataSetContents.containsAll(danglingDirContents)) {
                    operationLog.info("Deleting dangling HDF5 compression folder " + danglingHdf5DirName);
                    FileUtilities.deleteRecursively(danglingDataSetDir);
                } else {
                    operationLog.error(String.format("Unexpected set of contents '%s' in dangling directory '%s'. Only files with the following names '%s' are expected. Deletion of '%s' will be skipped.", danglingHdf5DirName, danglingDirContents, dataSetContents, danglingHdf5DirName));
                }
            }
        }

        private Collection<String> getDanglingDirContentsAsSet(File danglingDataSetDir) {
            List<File> files = FileUtilities.listFilesAndDirectories(danglingDataSetDir, false);
            ArrayList<String> result = new ArrayList<String>();
            for (File f : files) {
                result.add(f.getName());
            }
            return result;
        }

        private Collection<String> getDataSetContents(PhysicalDataSet dataSet) {
            IHierarchicalContent hierarchicalContent = ServiceProvider.getHierarchicalContentProvider().asContent(dataSet.getCode());
            ArrayList<String> result = new ArrayList<String>();
            try {
                for (IHierarchicalContentNode node : hierarchicalContent.getRootNode().getChildNodes()) {
                    result.add(node.getName());
                }
            }
            finally {
                hierarchicalContent.close();
            }
            return result;
        }
    }
}

