/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.TaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class PostRegistrationMaintenanceTask
implements IDataStoreLockingMaintenanceTask {
    @Private
    static final String POST_REGISTRATION_TASKS_PROPERTY = "post-registration-tasks";
    @Private
    static final String IGNORE_DATA_SETS = "ignore-data-sets-before-date";
    @Private
    static final String LAST_SEEN_DATA_SET_FILE_PROPERTY = "last-seen-data-set-file";
    private static final String DEFAULT_LAST_SEEN_DATA_SET_FILE = "last-seen-data-set.txt";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PostRegistrationMaintenanceTask.class);
    private IEncapsulatedOpenBISService service;
    private boolean needsLockOnDataStore;
    private Set<Map.Entry<String, IPostRegistrationTask>> tasks;
    private File lastSeenDataSetFile;
    private File newLastSeenDataSetFile;
    private Date ignoreBeforeDate;
    private TaskExecutor executor;

    @Override
    public boolean requiresDataStoreLock() {
        return this.needsLockOnDataStore;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        PropertyParametersUtil.SectionProperties[] sectionProperties;
        this.service = ServiceProvider.getOpenBISService();
        LinkedHashMap<String, IPostRegistrationTask> map = new LinkedHashMap<String, IPostRegistrationTask>();
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = sectionProperties = PropertyParametersUtil.extractSectionProperties(properties, POST_REGISTRATION_TASKS_PROPERTY, false);
        int n = sectionProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperty = sectionPropertiesArray[n2];
            Properties taskProperties = sectionProperty.getProperties();
            String className = PropertyUtils.getMandatoryProperty(taskProperties, "class");
            IPostRegistrationTask task = ClassUtils.create(IPostRegistrationTask.class, className, taskProperties, this.service);
            if (task.requiresDataStoreLock()) {
                this.needsLockOnDataStore = true;
            }
            map.put(sectionProperty.getKey(), task);
            ++n2;
        }
        this.tasks = map.entrySet();
        this.executor = new TaskExecutor(properties, operationLog);
        String fileName = properties.getProperty(LAST_SEEN_DATA_SET_FILE_PROPERTY, DEFAULT_LAST_SEEN_DATA_SET_FILE);
        this.lastSeenDataSetFile = new File(fileName);
        this.newLastSeenDataSetFile = new File(String.valueOf(fileName) + ".new");
        String property = properties.getProperty(IGNORE_DATA_SETS);
        if (property == null) {
            this.ignoreBeforeDate = new Date(0L);
        } else {
            try {
                this.ignoreBeforeDate = DateUtils.parseDate((String)property, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException parseException) {
                throw new ConfigurationFailureException("Invalid value of property 'ignore-data-sets-before-date': " + property);
            }
        }
    }

    public void setUpEmpty() {
        this.service = ServiceProvider.getOpenBISService();
        LinkedHashMap map = new LinkedHashMap();
        this.needsLockOnDataStore = false;
        this.tasks = map.entrySet();
        this.executor = new TaskExecutor(new Properties(), operationLog);
        String fileName = DEFAULT_LAST_SEEN_DATA_SET_FILE;
        this.lastSeenDataSetFile = new File(fileName);
        this.newLastSeenDataSetFile = new File(String.valueOf(fileName) + ".new");
        this.ignoreBeforeDate = new Date(0L);
    }

    @Override
    public void execute() {
        this.executor.cleanup();
        if (this.lastSeenDataSetFile.exists()) {
            String lastRegisteredCode = FileUtilities.loadToString(this.lastSeenDataSetFile).trim();
            this.service.markSuccessfulPostRegistration(lastRegisteredCode);
            this.deleteLastSeenDataSetId();
        }
        List<AbstractExternalData> dataSets = this.getDataSetsForPostRegistration();
        int i = 0;
        while (i < dataSets.size()) {
            AbstractExternalData dataSet = dataSets.get(i);
            String code = dataSet.getCode();
            operationLog.info("Post registration of " + (i + 1) + ". of " + dataSets.size() + " data sets: " + code);
            try {
                for (Map.Entry<String, IPostRegistrationTask> entry : this.tasks) {
                    IPostRegistrationTask task = entry.getValue();
                    String taskName = entry.getKey();
                    this.executor.execute(task, taskName, code, dataSet.isContainer());
                }
                this.saveLastSeenDataSetId(code);
                this.service.markSuccessfulPostRegistration(code);
                this.deleteLastSeenDataSetId();
            }
            catch (Throwable ex) {
                operationLog.error("Post registration failed.", ex);
                this.logPostponingMessage(dataSets, i);
                break;
            }
            ++i;
        }
    }

    private List<AbstractExternalData> getDataSetsForPostRegistration() {
        List<AbstractExternalData> dataSets = this.service.listDataSetsForPostRegistration();
        ArrayList<AbstractExternalData> filteredList = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataSet : dataSets) {
            if (dataSet.getRegistrationDate().getTime() <= this.ignoreBeforeDate.getTime()) continue;
            filteredList.add(dataSet);
        }
        Collections.sort(filteredList, new Comparator<AbstractExternalData>(){

            @Override
            public int compare(AbstractExternalData o1, AbstractExternalData o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        return filteredList;
    }

    private void saveLastSeenDataSetId(String lastRegisteredDataSetCode) {
        FileUtilities.writeToFile(this.newLastSeenDataSetFile, lastRegisteredDataSetCode);
        this.newLastSeenDataSetFile.renameTo(this.lastSeenDataSetFile);
    }

    private void deleteLastSeenDataSetId() {
        this.lastSeenDataSetFile.delete();
    }

    private void logPostponingMessage(List<AbstractExternalData> dataSets, int i) {
        int numberOfDataSets = dataSets.size();
        if (i < numberOfDataSets - 1) {
            ArrayList<String> codes = new ArrayList<String>();
            int j = i + 1;
            while (j < numberOfDataSets) {
                codes.add(dataSets.get(j).getCode());
                ++j;
            }
            operationLog.error("Because post registration task failed for data set " + dataSets.get(i).getCode() + " post registration tasks are postponed for " + "the following data sets: " + CollectionUtils.abbreviate(codes, 30));
        }
    }
}

