/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.monitor;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class DssRegistrationHealthMonitor {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DssRegistrationHealthMonitor.class);
    private IEncapsulatedOpenBISService openBisService;
    private final File recoveryStateDirectory;
    private final HashSet<String> unavailableResources;
    private static DssRegistrationHealthMonitor instance;
    private static Object instanceLocker;
    private static final String MESSAGE_RESOURCE_AVAILABLE = "The resource %s is now available";
    private static final String MESSAGE_RESOURCE_UNAVAILABLE = "The resource %s has become unavailable.";
    private static AtomicInteger counter;

    static {
        instanceLocker = new Object();
        counter = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DssRegistrationHealthMonitor getInstance(IEncapsulatedOpenBISService openBisService, File recoveryStateDirectory) {
        if (instance == null) {
            Object object = instanceLocker;
            synchronized (object) {
                if (instance == null) {
                    instance = new DssRegistrationHealthMonitor(openBisService, recoveryStateDirectory);
                }
            }
        }
        return instance;
    }

    public static DssRegistrationHealthMonitor getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The DssRegistrationHealthMonitor");
        }
        return instance;
    }

    public static void setOpenBisServiceForTest(IEncapsulatedOpenBISService openBisService) {
        if (instance != null) {
            DssRegistrationHealthMonitor.instance.openBisService = openBisService;
        }
    }

    private DssRegistrationHealthMonitor(IEncapsulatedOpenBISService openBisService, File recoveryStateDirectory) {
        this.openBisService = openBisService;
        this.recoveryStateDirectory = recoveryStateDirectory;
        this.unavailableResources = new HashSet();
    }

    public DssRegistrationHealthState checkHealthState(File dropboxDirectory) {
        if (!this.isFilesystemAvailable(dropboxDirectory)) {
            return DssRegistrationHealthState.FILE_SYSTEM_UNAVAILABLE;
        }
        if (!this.isRecoveryStateFileSystemAvailable()) {
            return DssRegistrationHealthState.RECOVERY_FILE_SYSTEM_UNAVAILABLE;
        }
        if (!this.isApplicationServerAlive()) {
            return DssRegistrationHealthState.APPLICATION_SERVER_UNAVAILABLE;
        }
        return DssRegistrationHealthState.HEALTHY;
    }

    private boolean updateKeyAvailability(String key, boolean isAvailable, String resourceName) {
        if (isAvailable && this.unavailableResources.contains(key)) {
            this.unavailableResources.remove(key);
            notificationLog.warn(String.format(MESSAGE_RESOURCE_AVAILABLE, resourceName));
        } else if (!isAvailable && !this.unavailableResources.contains(key)) {
            this.unavailableResources.add(key);
            notificationLog.warn(String.format(MESSAGE_RESOURCE_UNAVAILABLE, resourceName));
        }
        return isAvailable;
    }

    public boolean isApplicationServerAlive() {
        boolean isAvailable = this.checkApplicationServerAlive();
        return this.updateKeyAvailability("!!ApplicationServer", isAvailable, "Application server");
    }

    private boolean checkApplicationServerAlive() {
        try {
            this.openBisService.heartbeat();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isRecoveryStateFileSystemAvailable() {
        boolean isAvailable = this.checkFilesystemAvailable(this.recoveryStateDirectory);
        return this.updateKeyAvailability("!!recoveryFileSystem", isAvailable, "Dropboxes recovery state directory " + this.recoveryStateDirectory.getAbsolutePath());
    }

    public boolean isFilesystemAvailable(File path) {
        boolean isAvailable = this.checkFilesystemAvailable(path);
        return this.updateKeyAvailability(path.getAbsolutePath(), isAvailable, path.toString());
    }

    private boolean checkFilesystemAvailable(File path) {
        File temporaryFile = new File(path, "dss_health_monitor_" + counter.decrementAndGet() + ".tmp");
        try {
            temporaryFile.delete();
            return temporaryFile.createNewFile() && temporaryFile.delete();
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {}
        return false;
    }

    public static enum DssRegistrationHealthState {
        HEALTHY(true),
        FILE_SYSTEM_UNAVAILABLE,
        RECOVERY_FILE_SYSTEM_UNAVAILABLE,
        APPLICATION_SERVER_UNAVAILABLE;

        private final boolean isHealthy;

        private DssRegistrationHealthState() {
            this.isHealthy = false;
        }

        private DssRegistrationHealthState(boolean isHealthy) {
            this.isHealthy = isHealthy;
        }

        public boolean isUnavailable() {
            return !this.isHealthy;
        }
    }
}

