/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryAlgorithmWithState;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import java.io.File;
import java.io.Serializable;

public class DataSetStoragePrecommitRecoveryAlgorithm<T extends DataSetInformation>
implements Serializable,
IDataSetStorageRecoveryAlgorithmWithState<T> {
    private static final long serialVersionUID = 1L;
    private final DataSetStorageRecoveryAlgorithm<T> recoveryAlgorithm;
    private final IStorageProcessorTransactional.IStorageProcessorTransaction transaction;
    private final File markerFile;

    public DataSetStoragePrecommitRecoveryAlgorithm(T dataSetInformation, DataStoreStrategyKey dataStoreStrategyKey, File incomingDataSetFile, File stagingDirectory, File preCommitDirectory, String dataStoreCode, DataSetKind dataSetKind) {
        this.recoveryAlgorithm = new DataSetStorageRecoveryAlgorithm<T>(dataSetInformation, dataStoreStrategyKey, incomingDataSetFile, stagingDirectory, preCommitDirectory, dataStoreCode, null, dataSetKind);
        this.markerFile = null;
        this.transaction = null;
    }

    public DataSetStoragePrecommitRecoveryAlgorithm(T dataSetInformation, DataStoreStrategyKey dataStoreStrategyKey, File incomingDataSetFile, File stagingDirectory, File preCommitDirectory, String dataStoreCode, DataSetStorageAlgorithm.DataSetStoragePaths dataSetStoragePaths, File markerFile, IStorageProcessorTransactional.IStorageProcessorTransaction transaction) {
        this.recoveryAlgorithm = new DataSetStorageRecoveryAlgorithm<T>(dataSetInformation, dataStoreStrategyKey, incomingDataSetFile, stagingDirectory, preCommitDirectory, dataStoreCode, dataSetStoragePaths, DataSetKind.PHYSICAL);
        this.transaction = transaction;
        this.markerFile = markerFile;
    }

    public DataSetStorageAlgorithm<T> recoverDataSetStorageAlgorithm(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState state) {
        return this.recoveryAlgorithm.recoverDataSetStorageAlgorithm(state, this);
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction getTransaction() {
        return this.transaction;
    }

    public File getMarkerFile() {
        return this.markerFile;
    }

    public String getDataSetCode() {
        return this.recoveryAlgorithm.getDataSetCode();
    }

    public T getDataSetInformation() {
        return this.recoveryAlgorithm.getDataSetInformation();
    }

    public DataStoreStrategyKey getDataStoreStrategyKey() {
        return this.recoveryAlgorithm.getDataStoreStrategyKey();
    }

    public File getIncomingDataSetFile() {
        return this.recoveryAlgorithm.getIncomingDataSetFile();
    }

    public File getStagingDirectory() {
        return this.recoveryAlgorithm.getStagingDirectory();
    }

    public File getPreCommitDirectory() {
        return this.recoveryAlgorithm.getPreCommitDirectory();
    }

    public String getDataStoreCode() {
        return this.recoveryAlgorithm.getDataStoreCode();
    }

    public DataSetStorageAlgorithm.DataSetStoragePaths getDataSetStoragePaths() {
        return this.recoveryAlgorithm.getDataSetStoragePaths();
    }

    public DataSetStorageRecoveryAlgorithm<T> getRecoveryAlgorithm() {
        return this.recoveryAlgorithm;
    }

    @Override
    public DataSetStorageAlgorithm<T> createExternalDataSetStorageAlgorithm(IDataStoreStrategy dataStoreStrategy, IStorageProcessorTransactional storageProcessor, IFileOperations fileOperations, IMailClient mailClient) {
        return DataSetStorageAlgorithm.createFromPrecommittedRecoveryAlgorithm(dataStoreStrategy, storageProcessor, fileOperations, mailClient, this);
    }
}

