/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.validation.DataSetValidatorForTSV;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DataSetValidator
implements IDataSetValidator {
    static final String DATA_SET_VALIDATORS_KEY = "data-set-validators";
    static final String DATA_SET_TYPE_KEY = "data-set-type";
    static final String VALIDATOR_KEY = "validator";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetValidator.class);
    private final Map<String, IDataSetValidator> validators = new HashMap<String, IDataSetValidator>();

    public DataSetValidator(Properties properties) {
        PropertyParametersUtil.SectionProperties[] props;
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = props = PropertyParametersUtil.extractSectionProperties(properties, DATA_SET_VALIDATORS_KEY, false);
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            Properties validatorProperties = sectionProperties.getProperties();
            String dataSetType = validatorProperties.getProperty(DATA_SET_TYPE_KEY);
            if (dataSetType == null) {
                throw new ConfigurationFailureException("Missing mandatory property: " + sectionProperties.getKey() + "." + DATA_SET_TYPE_KEY);
            }
            try {
                IDataSetValidator validator = this.createValidator(validatorProperties);
                IDataSetValidator previous = this.validators.put(dataSetType, validator);
                if (previous == null) {
                    new ConfigurationFailureException("There is already a validator for data set type '" + dataSetType + "'.");
                }
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Validator for data set type '" + dataSetType + "' defined.");
                }
            }
            catch (CheckedExceptionTunnel ex) {
                throw new ConfigurationFailureException("Error occured while creating data set validator '" + sectionProperties.getKey() + "': " + ex.toString(), ex.getCause());
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Error occured while creating data set validator '" + sectionProperties.getKey() + "': " + ex.toString(), ex);
            }
            ++n2;
        }
    }

    private IDataSetValidator createValidator(Properties validatorProperties) {
        String validatorClass = validatorProperties.getProperty(VALIDATOR_KEY);
        if (validatorClass == null) {
            return new DataSetValidatorForTSV(validatorProperties);
        }
        return ClassUtils.create(IDataSetValidator.class, validatorClass, validatorProperties);
    }

    @Override
    public void assertValidDataSet(DataSetType dataSetType, File incomingDataSetFileOrFolder) {
        IDataSetValidator validator = this.validators.get(dataSetType.getCode());
        if (validator != null) {
            try {
                validator.assertValidDataSet(dataSetType, incomingDataSetFileOrFolder);
            }
            catch (Exception ex) {
                throw new UserFailureException("Data set of type '" + dataSetType.getCode() + "' is invalid: " + ex.getMessage(), ex);
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Data set [" + incomingDataSetFileOrFolder + "] of type '" + dataSetType.getCode() + "' successfully validated.");
            }
        }
    }

    @Override
    public void assertValidDataSet(DataSetType dataSetType, Reader reader, String dataSourceName) {
        IDataSetValidator validator = this.validators.get(dataSetType.getCode());
        if (validator != null) {
            try {
                validator.assertValidDataSet(dataSetType, reader, dataSourceName);
            }
            catch (Exception ex) {
                throw new UserFailureException("Data set of type '" + dataSetType.getCode() + "' is invalid: " + ex.getMessage(), ex);
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Data set [" + dataSourceName + "] of type '" + dataSetType.getCode() + "' successfully validated.");
            }
        }
    }
}

