/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public class MarkerLogApplicationListener
implements ApplicationListener {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MarkerLogApplicationListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        Object source = event.getSource();
        if (source instanceof AbstractApplicationContext) {
            AbstractApplicationContext appContext = (AbstractApplicationContext)source;
            if (this.isStartingEvent(event)) {
                if (appContext.getParent() != null) {
                    operationLog.info("SERVER STARTED");
                }
            } else if (this.isStoppingEvent(event) && appContext.getParent() == null) {
                operationLog.info("SERVER STOPPED");
            }
        }
    }

    private boolean isStartingEvent(ApplicationEvent event) {
        return event instanceof ContextStartedEvent || event instanceof ContextRefreshedEvent;
    }

    private boolean isStoppingEvent(ApplicationEvent event) {
        return event instanceof ContextClosedEvent;
    }
}

