/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic;

import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.etlserver.ETLDaemon;
import ch.systemsx.cisd.openbis.common.spring.SpringEoDSQLExceptionTranslator;
import ch.systemsx.cisd.openbis.dss.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.dss.generic.server.CommandQueueLister;
import ch.systemsx.cisd.openbis.dss.generic.shared.QueueingDataSetStatusUpdaterService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class DataStoreServer {
    private static final Logger notificationLog;
    private static final Thread.UncaughtExceptionHandler loggingExceptionHandler;

    static {
        SpringEoDSQLExceptionTranslator.activate();
        notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataStoreServer.class);
        loggingExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public final void uncaughtException(Thread t, Throwable e) {
                notificationLog.error("An exception has occurred [thread: '" + t.getName() + "'].", e);
            }
        };
    }

    private static void initLog() {
        LogInitializer.init();
        Thread.setDefaultUncaughtExceptionHandler(loggingExceptionHandler);
    }

    public static void main(String[] args) {
        boolean showCommandQueue;
        boolean showUpdaterQueue;
        boolean showShredder;
        if (args.length > 0 && args[0].equals("--version")) {
            System.err.println("Data Store Server version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion());
            System.exit(0);
        }
        DataStoreServer.initLog();
        boolean bl = showShredder = args.length > 0 && args[0].equals("--show-shredder");
        if (showShredder) {
            ETLDaemon.listShredder();
            System.exit(0);
        }
        boolean bl2 = showUpdaterQueue = args.length > 0 && args[0].equals("--show-updater-queue");
        if (showUpdaterQueue) {
            ETLDaemon.listUpdaterQueue();
            System.exit(0);
        }
        boolean bl3 = showCommandQueue = args.length > 0 && args[0].equals("--show-command-queue");
        if (showCommandQueue) {
            CommandQueueLister.listQueuedCommand();
            System.exit(0);
        }
        ExtendedProperties props = DssPropertyParametersUtil.loadProperties("etc/service.properties");
        File storeRootDir = DssPropertyParametersUtil.getStoreRootDir(props);
        QueueingPathRemoverService.start(storeRootDir, ETLDaemon.shredderQueueFile);
        QueueingDataSetStatusUpdaterService.start(ETLDaemon.updaterQueueFile);
        ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer.main(args);
        ETLDaemon.main(args);
    }
}

