/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AutoResolveUtils {
    public static List<File> findSomeMatchingFiles(File root, String path, String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return new ArrayList<File>();
        }
        ArrayList<File> result = new ArrayList<File>();
        AutoResolveUtils.findFiles(AutoResolveUtils.createStartingPoint(root, path), AutoResolveUtils.createCanonicalPathMatchingFilter(pattern), result);
        return result;
    }

    public static List<IHierarchicalContentNode> findSomeMatchingFiles(IHierarchicalContent rootContent, String path, String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return new ArrayList<IHierarchicalContentNode>();
        }
        String prefix = "";
        if (!StringUtils.isBlank((String)path)) {
            prefix = path;
            if (!path.endsWith(File.separator)) {
                prefix = String.valueOf(prefix) + File.separator;
            }
        }
        return rootContent.listMatchingNodes(String.valueOf(prefix) + pattern);
    }

    public static File tryGetTheOnlyMatchingFileOrDir(File root, String pattern) {
        if (root.isDirectory()) {
            if (AutoResolveUtils.continueAutoResolving(pattern, root)) {
                return AutoResolveUtils.tryGetTheOnlyMatchingFileOrDir(root.listFiles()[0], pattern);
            }
            return root;
        }
        if (root.isFile() && AutoResolveUtils.acceptFile(pattern, root)) {
            return root;
        }
        return null;
    }

    public static IHierarchicalContentNode tryGetTheOnlyMatchingFileOrDir(IHierarchicalContent root, String pattern) {
        return AutoResolveUtils.tryGetTheOnlyMatchingFileOrDir(root.getRootNode(), pattern);
    }

    public static IHierarchicalContentNode tryGetTheOnlyMatchingFileOrDir(IHierarchicalContentNode node, String pattern) {
        if (node.isDirectory()) {
            if (AutoResolveUtils.continueAutoResolving(pattern, node)) {
                return AutoResolveUtils.tryGetTheOnlyMatchingFileOrDir(node.getChildNodes().iterator().next(), pattern);
            }
            return node;
        }
        if (!node.isDirectory() && AutoResolveUtils.acceptFile(pattern, node)) {
            return node;
        }
        return null;
    }

    private static FileFilter createCanonicalPathMatchingFilter(final String pattern) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return AutoResolveUtils.acceptFile(pattern, pathname);
            }
        };
        return filter;
    }

    @Private
    static boolean acceptFile(String pattern, File file) {
        if (StringUtils.isBlank((String)pattern) || !file.isFile()) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(FileUtilities.getCanonicalPath(file));
        return m.find();
    }

    @Private
    static boolean acceptFile(String pattern, IHierarchicalContentNode node) {
        if (StringUtils.isBlank((String)pattern) || node.isDirectory()) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(node.getRelativePath());
        return m.find();
    }

    public static boolean continueAutoResolving(String mainDataSetPattern, File file) {
        assert (file != null);
        assert (file.isDirectory());
        return file.listFiles().length == 1 && (file.listFiles()[0].isDirectory() || AutoResolveUtils.acceptFile(mainDataSetPattern, file.listFiles()[0]));
    }

    public static boolean continueAutoResolving(String mainDataSetPattern, IHierarchicalContentNode node) {
        assert (node != null);
        assert (node.isDirectory());
        List<IHierarchicalContentNode> children = node.getChildNodes();
        if (children.size() == 1) {
            IHierarchicalContentNode onlyChild = (IHierarchicalContentNode)children.iterator().next();
            return onlyChild.isDirectory() || AutoResolveUtils.acceptFile(mainDataSetPattern, onlyChild);
        }
        return false;
    }

    private static void findFiles(File startingPoint, FileFilter filter, List<File> result) {
        File[] files;
        int n;
        if (result.size() > 1) {
            return;
        }
        File[] filteredFiles = startingPoint.listFiles(filter);
        if (filteredFiles != null) {
            File[] fileArray = filteredFiles;
            n = filteredFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result.add(f);
                ++n2;
            }
        }
        if ((files = startingPoint.listFiles()) != null) {
            File[] fileArray = files;
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File d = fileArray[n];
                if (d.isDirectory()) {
                    AutoResolveUtils.findFiles(d, filter, result);
                }
                ++n;
            }
        }
    }

    @Private
    static File createStartingPoint(File root, String path) {
        File tmp;
        File startingPoint = root;
        if (!StringUtils.isBlank((String)path) && (tmp = new File(root, path)).exists() && tmp.isDirectory()) {
            startingPoint = tmp;
        }
        return startingPoint;
    }
}

