/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.AutoResolveUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IErrorRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.PlainTextRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.RenderingContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.SimpleHTMLRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.Utils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.util.HttpRequestUtils;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class DatasetDownloadServlet
extends AbstractDatasetDownloadServlet {
    private static final long serialVersionUID = 1L;
    private static final String HTML_MODE_DISPLAY = "html";
    private static final String TEXT_MODE_DISPLAY = "txt";
    private static final String SIMPLE_HTML_MODE_DISPLAY = "simpleHtml";
    static final String AUTO_RESOLVE_KEY = "autoResolve";
    static final String FORCE_AUTO_RESOLVE_KEY = "forceAutoResolve";
    static final String MAIN_DATA_SET_PATH_KEY = "mdsPath";
    static final String MAIN_DATA_SET_PATTERN_KEY = "mdsPattern";
    private static String DOWNLOAD_URL;

    static void setDownloadUrl(String downloadUrl) {
        DOWNLOAD_URL = downloadUrl.endsWith("/") ? downloadUrl.substring(0, downloadUrl.length() - 1) : downloadUrl;
    }

    public DatasetDownloadServlet() {
    }

    DatasetDownloadServlet(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IRendererFactory rendererFactory = null;
        try {
            RequestParams requestParams = DatasetDownloadServlet.parseRequestURL(request, "datastore_server");
            rendererFactory = this.createRendererFactory(requestParams.getDisplayMode());
            HttpSession session = this.tryGetOrCreateSession(request, requestParams.tryGetSessionId());
            if (session == null) {
                DatasetDownloadServlet.printSessionExpired(response);
            } else {
                this.printResponse(response, rendererFactory, requestParams, session);
            }
        }
        catch (Exception e) {
            if (rendererFactory == null) {
                rendererFactory = new PlainTextRendererFactory();
            }
            this.printError(rendererFactory, request, response, e);
        }
    }

    private void printResponse(HttpServletResponse response, IRendererFactory rendererFactory, RequestParams requestParams, HttpSession session) throws UnsupportedEncodingException, IOException {
        String dataSetCode = requestParams.getDataSetCode();
        RenderingContext context = this.createRenderingContext(requestParams, dataSetCode, session);
        try {
            this.renderPage(rendererFactory, response, dataSetCode, context, requestParams, session);
        }
        finally {
            if (context != null && context.getRootContent() != null) {
                context.getRootContent().close();
            }
        }
    }

    private RenderingContext createRenderingContext(RequestParams requestParams, String dataSetCode, HttpSession session) {
        IHierarchicalContent rootContent = null;
        try {
            String sessionTokenOrNull = requestParams.tryGetSessionId();
            IHierarchicalContentProvider contentProvider = this.applicationContext.getHierarchicalContentProvider(sessionTokenOrNull);
            rootContent = contentProvider.asContent(dataSetCode);
        }
        catch (IllegalArgumentException ex) {
            throw new UserFailureException(ex.getMessage());
        }
        try {
            RenderingContext context = new RenderingContext(rootContent, requestParams.getURLPrefix(), requestParams.getPathInfo(), requestParams.tryGetSessionId());
            return context;
        }
        catch (IllegalArgumentException ex) {
            if (rootContent != null) {
                rootContent.close();
            }
            throw ex;
        }
    }

    private IRendererFactory createRendererFactory(String displayMode) {
        if (displayMode.equals(SIMPLE_HTML_MODE_DISPLAY) || displayMode.equals(HTML_MODE_DISPLAY)) {
            return new SimpleHTMLRendererFactory();
        }
        return new PlainTextRendererFactory();
    }

    private static RequestParams parseRequestURL(HttpServletRequest request, String applicationName) throws UnsupportedEncodingException {
        boolean shouldSetMainDataSetParamsToNull;
        String pathInfo;
        String dataSetCode;
        String urlPrefix = "/" + applicationName + "/";
        String requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        if (!requestURI.startsWith(urlPrefix)) {
            throw new EnvironmentFailureException("Request URI '" + requestURI + "' expected to start with '" + urlPrefix + "'.");
        }
        String fullPathInfo = requestURI.substring(urlPrefix.length());
        int indexOfFirstSeparator = fullPathInfo.indexOf(47);
        if (indexOfFirstSeparator < 0) {
            dataSetCode = fullPathInfo;
            pathInfo = "";
        } else {
            dataSetCode = fullPathInfo.substring(0, indexOfFirstSeparator);
            pathInfo = fullPathInfo.substring(indexOfFirstSeparator + 1);
        }
        String urlPrefixWithDataset = requestURI.substring(0, requestURI.length() - pathInfo.length());
        String sessionIDOrNull = request.getParameter("sessionID");
        String displayMode = DatasetDownloadServlet.getDisplayMode(request);
        Boolean autoResolveOrNull = Boolean.valueOf(request.getParameter(AUTO_RESOLVE_KEY));
        boolean autoResolve = autoResolveOrNull != null && autoResolveOrNull != false;
        Boolean forceAutoResolveOrNull = Boolean.valueOf(request.getParameter(FORCE_AUTO_RESOLVE_KEY));
        boolean forceAutoResolve = forceAutoResolveOrNull != null && forceAutoResolveOrNull != false;
        String mainDataSetPathOrNull = request.getParameter(MAIN_DATA_SET_PATH_KEY);
        String mainDataSetPatternOrNull = request.getParameter(MAIN_DATA_SET_PATTERN_KEY);
        boolean bl = shouldSetMainDataSetParamsToNull = !autoResolve && !forceAutoResolve;
        if (shouldSetMainDataSetParamsToNull || StringUtils.isBlank((String)mainDataSetPathOrNull)) {
            mainDataSetPathOrNull = null;
        }
        if (shouldSetMainDataSetParamsToNull || StringUtils.isBlank((String)mainDataSetPatternOrNull)) {
            mainDataSetPatternOrNull = null;
        }
        return new RequestParams(dataSetCode, pathInfo, sessionIDOrNull, urlPrefixWithDataset, displayMode, autoResolve, mainDataSetPathOrNull, mainDataSetPatternOrNull, forceAutoResolve);
    }

    private static String getDisplayMode(HttpServletRequest request) {
        String displayMode = request.getParameter("mode");
        if (displayMode == null) {
            displayMode = HTML_MODE_DISPLAY;
        }
        return displayMode;
    }

    private void printError(IRendererFactory rendererFactory, HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException {
        if (exception instanceof HighLevelException) {
            operationLog.error(exception.getMessage());
        } else if (operationLog.isInfoEnabled()) {
            StringBuffer url = request.getRequestURL();
            String queryString = request.getQueryString();
            if (StringUtils.isNotBlank((String)queryString)) {
                url.append("?").append(queryString);
            }
            operationLog.error("Request " + url + " caused an exception: ", exception);
        }
        String message = exception.getMessage();
        String errorText = StringUtils.isBlank((String)message) ? exception.toString() : message;
        IErrorRenderer errorRenderer = rendererFactory.createErrorRenderer();
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = response.getWriter();
        errorRenderer.setWriter(writer);
        errorRenderer.printErrorMessage(errorText);
        writer.flush();
        writer.close();
    }

    private void renderPage(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, RequestParams requestParams, HttpSession session) throws IOException {
        IHierarchicalContentNode node = renderingContext.getContentNode();
        if (!node.exists()) {
            throw new EnvironmentFailureException("Resource '" + node.getRelativePath() + "' does not exist in data set '" + dataSetCode + "'.");
        }
        String sessionIdOrNull = requestParams.tryGetSessionId();
        this.ensureDatasetAccessible(dataSetCode, session, sessionIdOrNull);
        if (node.isDirectory()) {
            if (requestParams.isAutoResolve()) {
                this.autoResolve(rendererFactory, response, dataSetCode, renderingContext, requestParams, session, node, false);
            } else if (requestParams.isForceAutoResolve()) {
                this.autoResolve(rendererFactory, response, dataSetCode, renderingContext, requestParams, session, node, true);
            } else {
                this.createPage(rendererFactory, response, dataSetCode, renderingContext, node);
            }
        } else {
            this.deliverFile(response, dataSetCode, node, requestParams.getDisplayMode());
        }
    }

    private void autoResolve(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, RequestParams requestParams, HttpSession session, IHierarchicalContentNode dirNode, boolean shouldForce) throws IOException {
        assert (dirNode.exists() && dirNode.isDirectory());
        List<IHierarchicalContentNode> mainDataSets = AutoResolveUtils.findSomeMatchingFiles(renderingContext.getRootContent(), requestParams.tryGetMainDataSetPath(), requestParams.tryGetMainDataSetPattern());
        if (mainDataSets.size() == 1 || mainDataSets.size() > 1 && shouldForce) {
            String newRelativePath = mainDataSets.get(0).getRelativePath();
            RenderingContext newRenderingContext = new RenderingContext(renderingContext, newRelativePath);
            DatasetDownloadServlet.autoResolveRedirect(response, newRenderingContext);
        } else if (AutoResolveUtils.continueAutoResolving(requestParams.tryGetMainDataSetPattern(), dirNode)) {
            assert (dirNode.getChildNodes().size() == 1);
            String childName = dirNode.getChildNodes().get(0).getName();
            String oldRelativePath = renderingContext.getRelativePath();
            String pathPrefix = StringUtils.isBlank((String)oldRelativePath) ? "" : String.valueOf(oldRelativePath) + "/";
            String newRelativePath = String.valueOf(pathPrefix) + childName;
            RenderingContext newRenderingContext = new RenderingContext(renderingContext, newRelativePath);
            DatasetDownloadServlet.autoResolveRedirect(response, newRenderingContext);
        } else {
            this.createPage(rendererFactory, response, dataSetCode, renderingContext, dirNode);
        }
    }

    private static void autoResolveRedirect(HttpServletResponse response, RenderingContext newContext) throws IOException {
        String urlPrefix = newContext.getUrlPrefix();
        String relativePath = newContext.getRelativePath();
        String sessionIdOrNull = newContext.getSessionIdOrNull();
        String newLocation = String.valueOf(DOWNLOAD_URL) + urlPrefix + "/" + relativePath + Utils.createUrlParameterForSessionId("?", sessionIdOrNull);
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("Auto resolve redirect: '%s', context: %s", newLocation, newContext));
        }
        response.sendRedirect(newLocation);
    }

    private void createPage(IRendererFactory rendererFactory, HttpServletResponse response, String dataSetCode, RenderingContext renderingContext, IHierarchicalContentNode dirNode) throws IOException {
        assert (dirNode.isDirectory());
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("For data set '%s' show directory '%s'", dataSetCode, dirNode.getRelativePath() == null ? "/" : dirNode.getRelativePath()));
        }
        IDirectoryRenderer directoryRenderer = rendererFactory.createDirectoryRenderer(renderingContext);
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = null;
        try {
            HttpRequestUtils.setNoCacheHeaders(response);
            writer = response.getWriter();
            directoryRenderer.setWriter(writer);
            directoryRenderer.printHeader();
            String relativeParentPath = renderingContext.getRelativeParentPath();
            if (relativeParentPath != null) {
                directoryRenderer.printLinkToParentDirectory(relativeParentPath);
            }
            List<IHierarchicalContentNode> children = dirNode.getChildNodes();
            HierarchicalContentUtils.sortNodes(children);
            for (IHierarchicalContentNode childNode : children) {
                String name = childNode.getName();
                String relativePath = childNode.getRelativePath();
                String normalizedRelativePath = relativePath.replace('\\', '/');
                if (childNode.isDirectory()) {
                    directoryRenderer.printDirectory(name, normalizedRelativePath);
                    continue;
                }
                Integer checksumOrNull = childNode.isChecksumCRC32Precalculated() ? Integer.valueOf(childNode.getChecksumCRC32()) : null;
                directoryRenderer.printFile(name, normalizedRelativePath, childNode.getFileLength(), checksumOrNull);
            }
            directoryRenderer.printFooter();
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private void deliverFile(HttpServletResponse response, String dataSetCode, IHierarchicalContentNode fileNode, String displayMode) throws IOException, FileNotFoundException {
        ResponseContentStream responseStream;
        String infoPostfix;
        assert (!fileNode.isDirectory());
        Size thumbnailSize = DatasetDownloadServlet.tryAsThumbnailDisplayMode(displayMode);
        if (thumbnailSize != null) {
            BufferedImage image = DatasetDownloadServlet.createThumbnail(fileNode, thumbnailSize);
            infoPostfix = " as a thumbnail.";
            responseStream = DatasetDownloadServlet.createResponseContentStream(image, fileNode.getName());
        } else {
            infoPostfix = ".";
            responseStream = DatasetDownloadServlet.createResponseContentStream(fileNode, displayMode);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info("For data set '" + dataSetCode + "' deliver file '" + fileNode.getRelativePath() + "' (" + responseStream.getSize() + " bytes)" + infoPostfix);
        }
        this.writeResponseContent(responseStream, response);
    }

    private static final ResponseContentStream createResponseContentStream(BufferedImage image, String fileNameOrNull) throws IOException {
        return ResponseContentStream.createPNG(image, fileNameOrNull);
    }

    private static ResponseContentStream createResponseContentStream(IHierarchicalContentNode contentNode, String displayMode) throws FileNotFoundException {
        String contentType = Utils.getMimeType(contentNode, displayMode.equals(TEXT_MODE_DISPLAY));
        return ResponseContentStream.create(contentNode.getInputStream(), contentNode.getFileLength(), contentType, contentNode.getName());
    }

    private static class RequestParams {
        private final String dataSetCode;
        private final String pathInfo;
        private final String sessionIdOrNull;
        private final String urlPrefixWithDataset;
        private final String displayMode;
        private final boolean autoResolve;
        private final String mainDataSetPathOrNull;
        private final String mainDataSetPatternOrNull;
        private final boolean forceAutoResolve;

        public RequestParams(String dataSetCode, String pathInfo, String sessionIdOrNull, String urlPrefixWithDataset, String displayMode, boolean autoResolve, String mainDataSetPathOrNull, String mainDataSetPatternOrNull, boolean forceAutoResolve) {
            this.dataSetCode = dataSetCode;
            this.pathInfo = pathInfo;
            this.sessionIdOrNull = sessionIdOrNull;
            this.urlPrefixWithDataset = urlPrefixWithDataset;
            this.displayMode = displayMode;
            this.autoResolve = autoResolve;
            this.mainDataSetPathOrNull = mainDataSetPathOrNull;
            this.mainDataSetPatternOrNull = mainDataSetPatternOrNull;
            this.forceAutoResolve = forceAutoResolve;
        }

        public boolean isAutoResolve() {
            return this.autoResolve;
        }

        public boolean isForceAutoResolve() {
            return this.forceAutoResolve;
        }

        public String getDataSetCode() {
            return this.dataSetCode;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String tryGetSessionId() {
            return this.sessionIdOrNull;
        }

        public String getDisplayMode() {
            return this.displayMode;
        }

        public String getURLPrefix() {
            return this.urlPrefixWithDataset;
        }

        public String tryGetMainDataSetPath() {
            return this.mainDataSetPathOrNull;
        }

        public String tryGetMainDataSetPattern() {
            return this.mainDataSetPatternOrNull;
        }
    }
}

