/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.DatasetImageOverviewConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.IDatasetImageOverviewPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageResolutionKind;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DatasetImageOverviewServlet
extends AbstractDatasetDownloadServlet {
    private static final long serialVersionUID = 1L;
    private static DatasetImageOverviewConfiguration configuration;

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestParams params = new RequestParams(request);
            String sessionId = params.sessionId;
            String datasetCode = params.datasetCode;
            String datasetTypeCode = params.datasetTypeCode;
            ImageResolutionKind resolution = params.resolution;
            HttpSession session = this.tryGetOrCreateSession(request, sessionId);
            if (session == null) {
                DatasetImageOverviewServlet.printSessionExpired(response);
                return;
            }
            this.ensureDatasetAccessible(datasetCode, session, sessionId);
            ResponseContentStream responseStream = this.createImageResponse(session, sessionId, datasetCode, datasetTypeCode, resolution);
            if (responseStream != null && operationLog.isDebugEnabled()) {
                operationLog.debug("Image for data set '" + datasetCode + "' of type " + datasetTypeCode + " was delivered.");
            }
            this.writeResponseContent(responseStream, response);
        }
        catch (Exception e) {
            operationLog.error("", e);
            DatasetImageOverviewServlet.printErrorResponse(response, "Invalid Request");
        }
    }

    private ResponseContentStream createImageResponse(HttpSession session, String sessionToken, String dataSetCode, String dataSetTypeCode, ImageResolutionKind resolution) {
        IHierarchicalContent content = this.applicationContext.getHierarchicalContentProvider(sessionToken).asContent(dataSetCode);
        IDatasetImageOverviewPlugin plugin = configuration.getDatasetImageOverviewPlugin(dataSetTypeCode);
        return plugin.createImageOverview(dataSetCode, dataSetTypeCode, content, resolution);
    }

    static void initConfiguration(Properties properties) {
        configuration = DatasetImageOverviewConfiguration.createConfiguration(properties);
    }

    protected static class RequestParams {
        private final String sessionId;
        private final String datasetCode;
        private final String datasetTypeCode;
        private final ImageResolutionKind resolution;

        public RequestParams(HttpServletRequest request) {
            this.sessionId = RequestParams.getRequiredParameter(request, "session_id");
            this.datasetCode = RequestParams.getRequiredParameter(request, "permId");
            this.datasetTypeCode = RequestParams.getRequiredParameter(request, "type");
            this.resolution = ImageResolutionKind.valueOf(RequestParams.getRequiredParameter(request, "resolution"));
        }

        private static String getRequiredParameter(HttpServletRequest request, String paramName) {
            String value = request.getParameter(paramName);
            if (value == null) {
                throw new UserFailureException("no value for the parameter " + paramName + " found in the URL");
            }
            return value;
        }
    }
}

