/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.LocalDataSetFileOperationsExcecutor;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class RemoteDataSetFileOperationsExecutor
implements IDataSetFileOperationsExecutor {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RemoteDataSetFileOperationsExecutor.class);
    private final ISshCommandExecutor executor;
    private final IPathCopier copier;
    private final String host;
    private final String rsyncModuleNameOrNull;
    private final String rsyncPasswordFileOrNull;
    private final File gfindExecutable;
    private final long timeoutInMillis;

    public RemoteDataSetFileOperationsExecutor(ISshCommandExecutor executor, IPathCopier copier, File gfindExecutable, String host, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, long timeoutInMillis) {
        this.executor = executor;
        this.copier = copier;
        this.host = host;
        this.rsyncModuleNameOrNull = rsyncModuleNameOrNull;
        this.rsyncPasswordFileOrNull = rsyncPasswordFileOrNull;
        this.gfindExecutable = gfindExecutable;
        this.timeoutInMillis = timeoutInMillis;
    }

    @Override
    public BooleanStatus exists(File file) {
        return this.executor.exists(file.getPath(), this.timeoutInMillis);
    }

    @Override
    public void deleteFolder(File folder) {
        ProcessResult result = this.executor.executeCommandRemotely("rm -rf " + folder.getPath(), this.timeoutInMillis);
        if (!result.isOK()) {
            operationLog.error("Remote deletion of '" + folder + "' failed with exit value: " + result.getExitValue());
            throw new ExceptionWithStatus(Status.createError("couldn't delete"));
        }
        List<String> output = result.getOutput();
        if (!output.isEmpty()) {
            operationLog.error("Remote deletion of '" + folder + "' seemed to be successful but produced following output:\n" + StringUtilities.concatenateWithNewLine(output));
            throw new ExceptionWithStatus(Status.createError("deletion leads to a problem"));
        }
    }

    @Override
    public void createFolder(File folder) {
        ProcessResult result = this.executor.executeCommandRemotely("mkdir -p " + folder.getPath(), this.timeoutInMillis);
        if (!result.isOK()) {
            operationLog.error("Remote creation of '" + folder + "' failed with exit value: " + result.getExitValue());
            throw new ExceptionWithStatus(Status.createError("couldn't create destination directory"));
        }
        List<String> output = result.getOutput();
        if (!output.isEmpty()) {
            operationLog.error("Remote creation of '" + folder + "' seemed to be successful but produced following output:\n" + StringUtilities.concatenateWithNewLine(output));
            throw new ExceptionWithStatus(Status.createError("creation of destination directory leads to a problem"));
        }
    }

    @Override
    public void copyDataSetToDestination(File dataSet, File destination) {
        Status result = this.copier.copyToRemote(dataSet, destination.getPath(), this.host, this.rsyncModuleNameOrNull, this.rsyncPasswordFileOrNull);
        if (result.isError()) {
            throw new ExceptionWithStatus(result);
        }
    }

    @Override
    public void syncDataSetWithDestination(File dataSet, File destination) {
        this.copyDataSetToDestination(dataSet, destination);
    }

    @Override
    public void retrieveDataSetFromDestination(File dataSet, File destination) {
        Status result = this.copier.copyFromRemote(destination.getPath(), this.host, dataSet, this.rsyncModuleNameOrNull, this.rsyncPasswordFileOrNull);
        if (result.isError()) {
            throw new ExceptionWithStatus(result);
        }
    }

    @Override
    public void renameTo(File newFile, File oldFile) {
        ProcessResult result = this.executor.executeCommandRemotely("mv " + oldFile.getPath() + " " + newFile.getPath(), this.timeoutInMillis);
        if (!result.isOK()) {
            operationLog.error("Remote move of '" + oldFile + "' to '" + newFile + "' failed with exit value: " + result.getExitValue());
            throw new ExceptionWithStatus(Status.createError("couldn't move"));
        }
        List<String> output = result.getOutput();
        if (!output.isEmpty()) {
            operationLog.error("Remote move of '" + oldFile + "' to '" + newFile + "' seemed to be successful but produced following output:\n" + StringUtilities.concatenateWithNewLine(output));
            throw new ExceptionWithStatus(Status.createError("moving leads to a problem"));
        }
    }

    @Override
    public void createMarkerFile(File markerFile) {
        ProcessResult result = this.executor.executeCommandRemotely("touch " + markerFile.getPath(), this.timeoutInMillis);
        if (!result.isOK()) {
            operationLog.error("Creation of marker file '" + markerFile + "' failed with exit value: " + result.getExitValue());
            throw new ExceptionWithStatus(Status.createError("creating a marker file failed"));
        }
        List<String> output = result.getOutput();
        if (!output.isEmpty()) {
            operationLog.error("Creation of marker file '" + markerFile + "' seemed to be successful but produced following output:\n" + StringUtilities.concatenateWithNewLine(output));
            throw new ExceptionWithStatus(Status.createError("creating a marker file leads to a problem"));
        }
    }

    @Override
    public BooleanStatus checkSame(File dataSet, File destination) {
        if (!dataSet.exists()) {
            return BooleanStatus.createFalse("Data set location '" + dataSet + "' doesn't exist");
        }
        BooleanStatus existsStatus = this.executor.exists(destination.getPath(), this.timeoutInMillis);
        if (!existsStatus.isSuccess()) {
            return existsStatus;
        }
        FileFilter nullFilter = null;
        List<File> storeFiles = FileUtilities.listFiles(dataSet, nullFilter, true);
        Map<String, Long> dataSetFileSizesByPaths = LocalDataSetFileOperationsExcecutor.FolderFileSizesReportGenerator.extractSizesByPaths(storeFiles, dataSet);
        String cmd = RemoteDataSetFileOperationsExecutor.createListFilesWithFileSizeCmd(destination.getPath(), this.gfindExecutable);
        ProcessResult result = this.executor.executeCommandRemotely(cmd, this.timeoutInMillis);
        if (!result.isOK()) {
            String errorOutput = StringUtilities.concatenateWithNewLine(result.getOutput());
            operationLog.error("Listing files in '" + destination + "' failed with exit value: " + result.getExitValue() + "; error output: " + errorOutput);
            return BooleanStatus.createError("listing files failed");
        }
        Map<String, Long> destinationFileSizesByPaths = this.extractDestinationFileSizesByPaths(result.getOutput(), destination);
        String inconsistenciesReport = LocalDataSetFileOperationsExcecutor.FolderFileSizesReportGenerator.findInconsistencies(dataSetFileSizesByPaths, destinationFileSizesByPaths);
        if (StringUtils.isBlank((String)inconsistenciesReport)) {
            return BooleanStatus.createTrue();
        }
        return BooleanStatus.createFalse("Inconsistencies:\n" + inconsistenciesReport);
    }

    @Override
    public long freeSpaceKb(String path) {
        throw new UnsupportedOperationException();
    }

    private Map<String, Long> extractDestinationFileSizesByPaths(List<String> output, File destination) {
        LinkedHashMap<String, Long> destinationFileSizesByPaths = new LinkedHashMap<String, Long>();
        for (String line : output) {
            String[] split = line.split("\t");
            if (split.length != 2) {
                throw new ExceptionWithStatus(Status.createError(String.format("Unexpected output from find in line: '%s'. Got %d tokens instead of 2.", line, split.length)));
            }
            String filePath = FileUtilities.getRelativeFilePath(destination, new File(split[0]));
            String fileSizeAsString = split[1];
            try {
                Long fileSize = Long.parseLong(fileSizeAsString);
                destinationFileSizesByPaths.put(filePath, fileSize);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExceptionWithStatus(Status.createError(String.format("Unexpected output from find in line: '%s'. Expected file size, got '%s'.", line, fileSizeAsString)));
            }
        }
        return destinationFileSizesByPaths;
    }

    private static String createListFilesWithFileSizeCmd(String path, File findExec) {
        return findExec + " " + path + " -type f -printf \"%p\\t%s\\n\"";
    }
}

