/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EchoDatabase
extends AbstractSearchDomainService {
    public EchoDatabase(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public List<SearchDomainSearchResult> search(String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        String resultStr = optionalParametersOrNull.get(sequenceSnippet);
        if (resultStr != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                HelperBean bean = (HelperBean)mapper.readValue(resultStr, HelperBean.class);
                ISearchDomainResultLocation resultLocation = bean.getResultLocation();
                SearchDomainSearchResult result = new SearchDomainSearchResult();
                result.setSearchDomain(bean.getSearchDomain());
                result.setResultLocation(resultLocation);
                return Collections.singletonList(result);
            }
            catch (Exception e) {
                throw CheckedExceptionTunnel.wrapIfNecessary(e);
            }
        }
        return Collections.emptyList();
    }

    public static final class HelperBean {
        private SearchDomain searchDomain = new SearchDomain();
        private DataSetFileSearchResultLocation dataSetFileResultLocation;
        private EntityPropertySearchResultLocation entityPropertyResultLocation;

        public ISearchDomainResultLocation getResultLocation() {
            return this.dataSetFileResultLocation == null ? this.entityPropertyResultLocation : this.dataSetFileResultLocation;
        }

        public SearchDomain getSearchDomain() {
            return this.searchDomain;
        }

        public void setSearchDomain(String searchDomain) {
            this.searchDomain.setName(searchDomain);
        }

        public void setDataSetCode(String dataSetCode) {
            this.getDataSetFileResultLocation().setCode(dataSetCode);
            this.getDataSetFileResultLocation().setPermId(dataSetCode);
        }

        public void setPathInDataSet(String path) {
            this.getDataSetFileResultLocation().setPathInDataSet(path);
        }

        public void setSequenceIdentifier(String identifier) {
            this.getDataSetFileResultLocation().setIdentifier(identifier);
        }

        public void setPositionInSequence(int position) {
            this.getDataSetFileResultLocation().setPosition(position);
        }

        public void setEntityKind(EntityKind entityKind) {
            this.getEntityPropertyResultLocation().setEntityKind(entityKind);
        }

        public void setEntityType(String entityType) {
            this.getEntityPropertyResultLocation().setEntityType(entityType);
        }

        public void setPermId(String permId) {
            this.getEntityPropertyResultLocation().setPermId(permId);
        }

        public void setCode(String code) {
            this.getEntityPropertyResultLocation().setCode(code);
        }

        public void setPropertyType(String propertyType) {
            this.getEntityPropertyResultLocation().setPropertyType(propertyType);
        }

        private DataSetFileSearchResultLocation getDataSetFileResultLocation() {
            if (this.dataSetFileResultLocation == null) {
                this.dataSetFileResultLocation = new DataSetFileSearchResultLocation();
            }
            return this.dataSetFileResultLocation;
        }

        private EntityPropertySearchResultLocation getEntityPropertyResultLocation() {
            if (this.entityPropertyResultLocation == null) {
                this.entityPropertyResultLocation = new EntityPropertySearchResultLocation();
            }
            return this.entityPropertyResultLocation;
        }
    }
}

