/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpServerConfig {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FtpServerConfig.class);
    private static final String PREFIX = "ftp.server.";
    static final String ENABLE_KEY = "ftp.server.enable";
    static final String SFTP_PORT_KEY = "ftp.server.sftp-port";
    static final String LEGACY_FTP_PORT_KEY = "ftp.server.port";
    static final String FTP_PORT_KEY = "ftp.server.ftp-port";
    static final String USE_SSL_KEY = "ftp.server.use-ssl";
    static final String IMPLICIT_SSL_KEY = "ftp.server.implicit-ssl";
    static final String MAX_THREADS_KEY = "ftp.server.maxThreads";
    static final String DATASET_DISPLAY_TEMPLATE_KEY = "ftp.server.dataset.display.template";
    static final String DATASET_FILELIST_SUBPATH_KEY = "ftp.server.dataset.filelist.subpath.";
    static final String DATASET_FILELIST_FILTER_KEY = "ftp.server.dataset.filelist.filter.";
    static final String ACTIVE_MODE_ENABLE_KEY = "ftp.server.activemode.enable";
    static final String ACTIVE_PORT_KEY = "ftp.server.activemode.port";
    static final String PASSIVE_MODE_PORT_RANGE_KEY = "ftp.server.passivemode.port.range";
    static final String SHOW_PARENTS_AND_CHILDREN_KEY = "ftp.server.dataset.show-parents-and-children";
    private static final int DEFAULT_ACTIVE_PORT = 2122;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final boolean DEFAULT_IMPLICIT_SSL = false;
    private static final int DEFAULT_MAX_THREADS = 25;
    private static final String DEFAULT_DATASET_TEMPLATE = "${dataSetCode}";
    private static final String DEFAULT_PASSIVE_PORTS = "2130-2140";
    private boolean startServer;
    private int ftpPort;
    private boolean ftpMode;
    private boolean activeModeEnabled;
    private int activePort;
    private String passivePortsRange;
    private boolean useSSL;
    private boolean implicitSSL;
    private File keyStore;
    private String keyPassword;
    private String keyStorePassword;
    private String dataSetDisplayTemplate = "";
    private int maxThreads;
    private Map<String, String> fileListSubPaths = new HashMap<String, String>();
    private Map<String, String> fileListFilters = new HashMap<String, String>();
    private boolean showParentsAndChildren;
    private boolean sftpMode;
    private int sftpPort;

    public FtpServerConfig(Properties props) {
        this.startServer = PropertyUtils.getBoolean(props, ENABLE_KEY, false);
        if (this.startServer) {
            this.initializeProperties(props);
        }
    }

    private void initializeProperties(Properties props) {
        this.sftpPort = PropertyUtils.getInt(props, SFTP_PORT_KEY, 0);
        this.sftpMode = this.sftpPort > 0;
        this.ftpPort = PropertyUtils.getPosInt(props, FTP_PORT_KEY, 0);
        if (this.ftpPort == 0) {
            this.ftpPort = PropertyUtils.getPosInt(props, LEGACY_FTP_PORT_KEY, 0);
        }
        this.ftpMode = this.ftpPort > 0;
        this.useSSL = PropertyUtils.getBoolean(props, USE_SSL_KEY, true);
        if (this.sftpMode || this.useSSL) {
            this.initializeSSLProperties(props);
        }
        this.activeModeEnabled = PropertyUtils.getBoolean(props, ACTIVE_MODE_ENABLE_KEY, false);
        this.activePort = PropertyUtils.getPosInt(props, ACTIVE_PORT_KEY, 2122);
        this.passivePortsRange = PropertyUtils.getProperty(props, PASSIVE_MODE_PORT_RANGE_KEY, DEFAULT_PASSIVE_PORTS);
        this.maxThreads = PropertyUtils.getPosInt(props, MAX_THREADS_KEY, 25);
        this.dataSetDisplayTemplate = PropertyUtils.getProperty(props, DATASET_DISPLAY_TEMPLATE_KEY, DEFAULT_DATASET_TEMPLATE);
        this.showParentsAndChildren = PropertyUtils.getBoolean(props, SHOW_PARENTS_AND_CHILDREN_KEY, false);
        ExtendedProperties fileListSubPathProps = ExtendedProperties.getSubset(props, DATASET_FILELIST_SUBPATH_KEY, true);
        for (Object key : fileListSubPathProps.keySet()) {
            String dataSetType = key.toString();
            String subPath = fileListSubPathProps.getProperty(dataSetType);
            this.fileListSubPaths.put(dataSetType, subPath);
        }
        ExtendedProperties fileListFilterProps = ExtendedProperties.getSubset(props, DATASET_FILELIST_FILTER_KEY, true);
        for (Object key : fileListFilterProps.keySet()) {
            String dataSetType = key.toString();
            String filter = fileListFilterProps.getProperty(dataSetType);
            this.fileListFilters.put(dataSetType, filter);
        }
    }

    private void initializeSSLProperties(Properties props) {
        String keyStoreFileName = PropertyUtils.getMandatoryProperty(props, "keystore.path");
        this.keyStore = new File(keyStoreFileName);
        this.keyStorePassword = PropertyUtils.getMandatoryProperty(props, "keystore.password");
        this.keyPassword = PropertyUtils.getMandatoryProperty(props, "keystore.key-password");
        this.implicitSSL = PropertyUtils.getBoolean(props, IMPLICIT_SSL_KEY, false);
    }

    public boolean isSftpMode() {
        return this.sftpMode;
    }

    public int getSftpPort() {
        return this.sftpPort;
    }

    public boolean isStartServer() {
        return this.startServer;
    }

    public boolean isFtpMode() {
        return this.ftpMode;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isImplicitSSL() {
        return this.implicitSSL;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public String getDataSetDisplayTemplate() {
        return this.dataSetDisplayTemplate;
    }

    public boolean isShowParentsAndChildren() {
        return this.showParentsAndChildren;
    }

    public Map<String, String> getFileListSubPaths() {
        return Collections.unmodifiableMap(this.fileListSubPaths);
    }

    public Map<String, String> getFileListFilters() {
        return Collections.unmodifiableMap(this.fileListFilters);
    }

    public void logStartupInfo() {
        String message;
        if (this.ftpMode) {
            operationLog.info("FTP Server port: " + this.ftpPort);
            operationLog.info("FTP Server using SSL: " + this.useSSL);
            operationLog.info("FTP Server passive ports: " + this.passivePortsRange);
            operationLog.info("FTP Server enable active mode: " + this.activeModeEnabled);
            if (this.activeModeEnabled) {
                operationLog.info("FTP Server active mode port: " + this.activePort);
            }
        }
        if (this.sftpMode) {
            operationLog.info("SFTP Server port: " + this.sftpPort);
        }
        operationLog.info("SFTP/FTP Server data set display template : " + this.dataSetDisplayTemplate);
        for (Map.Entry<String, String> subpathEntry : this.fileListSubPaths.entrySet()) {
            message = String.format("SFTP/FTP Server subpath configuration for data set type '%s' : '%s'", subpathEntry.getKey(), subpathEntry.getValue());
            operationLog.info(message);
        }
        for (Map.Entry<String, String> filterEntry : this.fileListFilters.entrySet()) {
            message = String.format("SFTP/FTP Server file filter configuration for data set type '%s' : '%s'", filterEntry.getKey(), filterEntry.getValue());
            operationLog.info(message);
        }
    }

    public boolean isActiveModeEnabled() {
        return this.activeModeEnabled;
    }

    public int getActiveLocalPort() {
        return this.activePort;
    }

    public String getPassivePortsRange() {
        return this.passivePortsRange;
    }
}

