/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.demo;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.IDatasetImageOverviewPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageResolutionKind;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;

public class DemoOverviewPlugin
implements IDatasetImageOverviewPlugin {
    private static final String LABEL_PROPERTY_KEY = "label";
    private static final String SMALL_IMAGE_FILE = "resource/overview-small.png";
    private static final String NORMAL_IMAGE_FILE = "resource/overview-normal.png";
    private final String label;

    public DemoOverviewPlugin(Properties properties) {
        this.label = PropertyUtils.getProperty(properties, LABEL_PROPERTY_KEY, "(no label)");
    }

    @Override
    public ResponseContentStream createImageOverview(String datasetCode, String datasetTypeCode, IHierarchicalContent datasetRoot, ImageResolutionKind resolution) {
        String imageFilePath;
        System.out.println(String.format("%s (%s): create image for\n\tdataset code: %s\n\tdataset type: %s\n\tresolution: %s", new Object[]{this.getClass().getSimpleName(), this.label, datasetCode, datasetTypeCode, resolution}));
        switch (resolution) {
            case SMALL: {
                imageFilePath = SMALL_IMAGE_FILE;
                break;
            }
            case NORMAL: {
                imageFilePath = NORMAL_IMAGE_FILE;
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)resolution) + " resolution is not supported");
            }
        }
        try {
            BufferedImage image = this.createImage(imageFilePath, datasetCode, datasetTypeCode, resolution);
            return ResponseContentStream.createPNG(image, imageFilePath);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private BufferedImage createImage(String imageFilePath, String datasetCode, String datasetType, ImageResolutionKind resolution) throws IOException {
        BufferedImage image = ImageIO.read(new File(imageFilePath));
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.BLACK);
        graphics.setFont(graphics.getFont().deriveFont(1));
        switch (resolution) {
            case SMALL: {
                graphics.drawString("" + datasetCode.charAt(datasetCode.length() - 1), 11, 21);
                break;
            }
            case NORMAL: {
                graphics.drawString(this.getClass().getSimpleName(), 10, 20);
                graphics.drawString("Plugin Label: " + this.label, 10, 40);
                graphics.drawString("Data Set Code: " + datasetCode, 10, 60);
                graphics.drawString("Data Set Type: " + datasetType, 10, 80);
            }
        }
        return image;
    }
}

