/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IImmutableCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Copier
implements Serializable,
IPostRegistrationDatasetHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Copier.class);
    private final File rsyncExecutable;
    private final File sshExecutable;
    private File lnExecutable;
    private final String hostFile;
    private final String rsyncPasswordFile;
    private final IPathCopierFactory pathCopierFactory;
    private final ISshCommandExecutorFactory sshCommandExecutorFactory;
    private final IImmutableCopierFactory immutableCopierFactory;
    private final boolean renameToDataSetCode;
    private final boolean hardLinkCopy;

    public Copier(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, IImmutableCopierFactory immutableCopierFactory) {
        this.pathCopierFactory = pathCopierFactory;
        this.sshCommandExecutorFactory = sshCommandExecutorFactory;
        this.immutableCopierFactory = immutableCopierFactory;
        this.rsyncPasswordFile = properties.getProperty("rsync-password-file");
        this.rsyncExecutable = Copier.getExecutable(properties, "rsync");
        this.sshExecutable = Copier.getExecutable(properties, "ssh");
        this.hostFile = PropertyUtils.getMandatoryProperty(properties, "destination");
        this.renameToDataSetCode = PropertyUtils.getBoolean(properties, "rename-to-dataset-code", false);
        this.hardLinkCopy = PropertyUtils.getBoolean(properties, "hard-link-copy", false);
        if (this.hardLinkCopy) {
            String host = HostAwareFileWithHighwaterMark.create(this.hostFile, -1L).tryGetHost();
            if (host != null) {
                throw new ConfigurationFailureException("Hard link copying not possible on an unmounted destination on host '" + host + "'.");
            }
            this.lnExecutable = Copier.getExecutable(properties, "ln");
        }
    }

    protected String transformHostFile(String originalHostFile, Map<String, String> parameterBindings) {
        return originalHostFile;
    }

    @Override
    public Status handle(File originalData, DataSetInformation dataSetInformation, Map<String, String> parameterBindings) {
        Status status;
        HostAwareFileWithHighwaterMark hostAwareFile = HostAwareFileWithHighwaterMark.create(this.transformHostFile(this.hostFile, parameterBindings), -1L);
        String host = hostAwareFile.tryGetHost();
        ISshCommandExecutor sshCommandExecutor = this.sshCommandExecutorFactory.create(this.sshExecutable, host);
        String rsyncModule = hostAwareFile.tryGetRsyncModule();
        IPathCopier copier = this.pathCopierFactory.create(this.rsyncExecutable, this.sshExecutable, 15000L);
        copier.check();
        if (host != null) {
            FileUtilities.checkPathCopier(copier, host, null, rsyncModule, this.rsyncPasswordFile, 15000L);
        }
        String destination = hostAwareFile.getPath();
        File destinationFile = new File(destination, originalData.getName());
        String dataSetCode = dataSetInformation.getDataSetCode();
        File finalDestinationFile = new File(destination, this.renameToDataSetCode ? dataSetCode : originalData.getName());
        BooleanStatus destinationExists = this.checkDestinationFileExistence(finalDestinationFile, host, sshCommandExecutor);
        if (destinationExists.isSuccess()) {
            operationLog.error("Destination file/directory '" + finalDestinationFile.getPath() + "' already exists - dataset files will not be copied.");
            return Status.createError("already exist");
        }
        if (destinationExists.isError()) {
            operationLog.error("Could not test destination file/directory '" + finalDestinationFile + "' existence" + (host != null ? " on host '" + host + "'" : "") + ": " + destinationExists.tryGetMessage());
            return Status.createError("copying failed");
        }
        if (this.hardLinkCopy) {
            IImmutableCopier hardLinkMaker = this.immutableCopierFactory.create(this.rsyncExecutable, this.lnExecutable);
            status = hardLinkMaker.copyImmutably(originalData, new File(destination), this.renameToDataSetCode ? dataSetCode : null);
        } else {
            status = copier.copyToRemote(originalData, destination, host, rsyncModule, this.rsyncPasswordFile);
        }
        if (status.isError()) {
            operationLog.error("Could not copy data set " + dataSetCode + " to destination folder '" + destination + "'" + (host != null ? " on host '" + host + "'" : "") + (rsyncModule != null ? " for rsync module '" + rsyncModule + "'" : "") + ": " + status);
            return Status.createError("copying failed");
        }
        if (!this.hardLinkCopy && this.renameToDataSetCode) {
            if (host == null) {
                if (!destinationFile.renameTo(finalDestinationFile)) {
                    operationLog.error("Moving of '" + destinationFile.getPath() + "' to '" + finalDestinationFile + "' failed.");
                    return Status.createError("couldn't rename");
                }
            } else {
                String newFilePath = finalDestinationFile.getPath();
                ProcessResult result = sshCommandExecutor.executeCommandRemotely("mv " + destinationFile.getPath() + " " + newFilePath, 15000L);
                if (!result.isOK()) {
                    operationLog.error("Remote move of '" + destinationFile.getPath() + "' to '" + newFilePath + "' failed with exit value: " + result.getExitValue());
                    return Status.createError("couldn't rename");
                }
            }
        }
        return status;
    }

    private BooleanStatus checkDestinationFileExistence(File destinationFile, String hostOrNull, ISshCommandExecutor sshCommandExecutor) {
        if (hostOrNull != null) {
            return sshCommandExecutor.exists(destinationFile.getPath(), 15000L);
        }
        return BooleanStatus.createFromBoolean(destinationFile.exists());
    }

    @Override
    public void undoLastOperation() {
    }

    public static File getExecutable(Properties properties, String executable) {
        File executableFile;
        String executableProperty = properties.getProperty(String.valueOf(executable) + "-executable");
        if (executableProperty != null) {
            executableFile = new File(executableProperty);
        } else {
            executableFile = OSUtilities.findExecutable(executable);
            if (executableFile == null) {
                throw new ConfigurationFailureException("Could not found path to executable '" + executable + "'.");
            }
        }
        if (!executableFile.isFile()) {
            throw new ConfigurationFailureException("Path to executable '" + executable + "' is not a file: " + executableFile.getAbsolutePath());
        }
        return executableFile;
    }
}

