/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.action.AbstractDelegatedActionWithResult;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.etlserver.DefaultStorageProcessor;
import ch.systemsx.cisd.etlserver.DssUniqueFilenameGenerator;
import ch.systemsx.cisd.etlserver.DynamicTransactionQueryFactory;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPreStagingBehavior;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v2.DataSetRegistrationTransactionV2Delegate;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryManager;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v2.DefaultDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v2.IOmniscientEntityRegistrator;
import ch.systemsx.cisd.etlserver.validation.DataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AggregationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;

public abstract class IngestionService<T extends DataSetInformation>
extends AggregationService
implements IOmniscientEntityRegistrator<T> {
    private static final String AGGREGATION_SERVICE_SCRATCH_DIR_NAME = "aggregation-service";
    private static final long serialVersionUID = 1L;
    private final Properties dssProperties;
    private IEncapsulatedOpenBISService openBisService;
    private final IMailClient mailClient;
    private final DssUniqueFilenameGenerator filenameGenerator;

    private static IMailClient getMailClientFromProperties(Properties dssProperties) {
        Properties mailProperties = Parameters.createMailProperties(dssProperties);
        return new MailClient(mailProperties);
    }

    public IngestionService(Properties properties, File storeRoot) {
        this((Properties)DssPropertyParametersUtil.loadServiceProperties(), properties, storeRoot);
    }

    public IngestionService(Properties dssProperties, Properties instanceProperties, File storeRoot) {
        this(dssProperties, instanceProperties, storeRoot, null, IngestionService.getMailClientFromProperties(dssProperties));
    }

    public IngestionService(Properties dssProperties, Properties instanceProperties, File storeRoot, IEncapsulatedOpenBISService openBisService, IMailClient mailClient) {
        super(instanceProperties, storeRoot);
        this.dssProperties = dssProperties;
        this.openBisService = openBisService;
        this.mailClient = mailClient;
        this.filenameGenerator = new DssUniqueFilenameGenerator("mock", "file", "serialized");
    }

    @Override
    public final TableModel createAggregationReport(Map<String, Object> parameters, DataSetProcessingContext context) {
        DataSetRegistrationService<T> service = null;
        try {
            service = this.createRegistrationService(parameters);
            if (context.trySessionToken() != null) {
                service.setUserSessionToken(context.trySessionToken());
            }
            IDataSetRegistrationTransactionV2 transaction = this.createTransaction(service);
            TableModel tableModel = this.process(transaction, parameters, context);
            service.commit();
            if (service.encounteredErrors.size() > 0) {
                throw service.encounteredErrors.get(0);
            }
            TableModel tableModel2 = tableModel;
            return tableModel2;
        }
        catch (Throwable e) {
            if (service != null) {
                service.abort(e);
            }
            this.logInvocationError(parameters, e);
            TableModel tableModel = this.errorTableModel(parameters, e);
            return tableModel;
        }
        finally {
            if (service != null) {
                service.cleanAfterRegistrationIfNecessary();
            }
        }
    }

    protected IDataSetRegistrationTransactionV2 createTransaction(DataSetRegistrationService<T> service) {
        return new DataSetRegistrationTransactionV2Delegate(service.transaction());
    }

    protected abstract TableModel process(IDataSetRegistrationTransactionV2 var1, Map<String, Object> var2, DataSetProcessingContext var3);

    private File getShare() {
        return new File(this.storeRoot, this.getShareId());
    }

    private File getServiceScratchDir() {
        return new File(this.getShare(), AGGREGATION_SERVICE_SCRATCH_DIR_NAME);
    }

    protected File getMockIncomingDir() {
        File incomingDir = new File(this.getServiceScratchDir(), "incoming");
        if (!incomingDir.exists()) {
            incomingDir.mkdirs();
        }
        return incomingDir;
    }

    protected DataSetRegistrationService<T> createRegistrationService(Map<String, Object> parameters) {
        DssRegistrationHealthMonitor.getInstance(this.getGlobalState().getOpenBisService(), this.getGlobalState().getRecoveryStateDir());
        try {
            final File mockIncomingDataSetFile = this.createMockIncomingFile(parameters);
            DataSetFile incoming = new DataSetFile(mockIncomingDataSetFile);
            AbstractDelegatedActionWithResult<Boolean> cleanUpAction = new AbstractDelegatedActionWithResult<Boolean>(Boolean.valueOf(true)){

                @Override
                public Boolean execute() {
                    mockIncomingDataSetFile.delete();
                    return true;
                }
            };
            DataSetRegistrationPreStagingBehavior preStagingUsage = DataSetRegistrationPreStagingBehavior.USE_ORIGINAL;
            AbstractOmniscientTopLevelDataSetRegistrator.NoOpDelegate delegate = new AbstractOmniscientTopLevelDataSetRegistrator.NoOpDelegate(preStagingUsage);
            DataSetRegistrationService<T> service = this.createRegistrationService(incoming, (IDelegatedActionWithResult<Boolean>)cleanUpAction, delegate);
            return service;
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    protected DataSetRegistrationService<T> createRegistrationService(DataSetFile incoming, IDelegatedActionWithResult<Boolean> cleanUpAction, AbstractOmniscientTopLevelDataSetRegistrator.NoOpDelegate delegate) {
        DefaultDataSetRegistrationDetailsFactory registrationDetailsFactory = new DefaultDataSetRegistrationDetailsFactory(this.getRegistratorState(), null);
        DataSetRegistrationService<DataSetInformation> service = new DataSetRegistrationService<DataSetInformation>(this, incoming, registrationDetailsFactory, cleanUpAction, delegate);
        return service;
    }

    protected File createMockIncomingFile(Map<String, Object> parameters) throws IOException {
        HashMap<String, Object> parameterHashMap = new HashMap<String, Object>(parameters);
        File mockIncomingDataSetFile = new File(this.getMockIncomingDir(), this.filenameGenerator.generateFilename());
        mockIncomingDataSetFile.createNewFile();
        FileUtilities.writeToFile(mockIncomingDataSetFile, parameterHashMap);
        return mockIncomingDataSetFile;
    }

    @Override
    public File getRollBackStackParentFolder() {
        return this.getServiceScratchDir();
    }

    @Override
    public TopLevelDataSetRegistratorGlobalState getGlobalState() {
        return this.getRegistratorState().getGlobalState();
    }

    @Override
    public AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState getRegistratorState() {
        IStorageProcessorTransactional storageProcessor = this.createStorageProcessor();
        storageProcessor.setStoreRootDirectory(this.storeRoot);
        IDataSetOnErrorActionDecision onErrorActionDecision = this.createOnErrorActionDecision();
        AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState = new AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState(this.createGlobalState(), storageProcessor, new ReentrantLock(), FileOperations.getMonitoredInstanceForCurrentThread(), onErrorActionDecision);
        return registratorState;
    }

    private IDataSetOnErrorActionDecision createOnErrorActionDecision() {
        return new IDataSetOnErrorActionDecision(){

            @Override
            public IStorageProcessorTransactional.UnstoreDataAction computeUndoAction(IDataSetOnErrorActionDecision.ErrorType errorType, Throwable failureOrNull) {
                return IStorageProcessorTransactional.UnstoreDataAction.DELETE;
            }
        };
    }

    protected IStorageProcessorTransactional createStorageProcessor() {
        return new DefaultStorageProcessor(this.properties);
    }

    protected TopLevelDataSetRegistratorGlobalState createGlobalState() {
        File dssInternalTempDir = DssPropertyParametersUtil.getDssInternalTempDir(this.dssProperties);
        File dssRegistrationLogDir = DssPropertyParametersUtil.getDssRegistrationLogDir(this.dssProperties);
        File dssRecoveryStateDir = DssPropertyParametersUtil.getDssRecoveryStateDir(this.dssProperties);
        String dssCode = DssPropertyParametersUtil.getDataStoreCode(this.dssProperties);
        String shareId = this.getShareId();
        DataSetValidator dataSetValidator = new DataSetValidator(this.dssProperties);
        DataSourceQueryService dataSourceQueryService = new DataSourceQueryService();
        ThreadParameters threadParameters = this.createThreadParameters();
        TopLevelDataSetRegistratorGlobalState globalState = new TopLevelDataSetRegistratorGlobalState(dssCode, shareId, this.storeRoot, dssInternalTempDir, dssRegistrationLogDir, dssRecoveryStateDir, this.getOpenBisService(), this.mailClient, dataSetValidator, dataSourceQueryService, new DynamicTransactionQueryFactory(), this.shouldNotifySuccessfulRegistration(), threadParameters, new DataSetStorageRecoveryManager());
        return globalState;
    }

    protected ThreadParameters createThreadParameters() {
        Properties threadParameterProperties = new Properties();
        threadParameterProperties.put("incoming-dir", this.getMockIncomingDir().getAbsolutePath());
        return new ThreadParameters(threadParameterProperties, this.getClass().getSimpleName());
    }

    private IEncapsulatedOpenBISService getOpenBisService() {
        if (this.openBisService != null) {
            return this.openBisService;
        }
        this.openBisService = ServiceProvider.getOpenBISService();
        return this.openBisService;
    }

    protected String getShareId() {
        return "1";
    }

    protected boolean shouldNotifySuccessfulRegistration() {
        return false;
    }

    protected TableModel errorTableModel(Map<String, Object> parameters, Throwable e) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader("Parameters");
        builder.addHeader("Error");
        IRowBuilder row = builder.addRow();
        row.setCell("Parameters", parameters.toString());
        row.setCell("Error", e.getMessage());
        return builder.getTableModel();
    }

    protected void logInvocationError(Map<String, Object> parameters, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error producing aggregation report\n");
        sb.append("Class: ");
        sb.append(this.getClass().getName());
        sb.append("\n");
        sb.append("Parameters: ");
        sb.append(parameters);
        operationLog.error(sb.toString(), e);
    }

    @Override
    public void didRollbackTransaction(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex) {
    }

    @Override
    public void didCommitTransaction(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction) {
    }

    @Override
    public void didPreRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
    }

    @Override
    public void didPostRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
    }

    @Override
    public void didEncounterSecondaryTransactionErrors(DataSetRegistrationService<T> dataSetRegistrationService, DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
    }
}

