/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.TableCellUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IterativeTableModelBuilder {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IterativeTableModelBuilder.class);
    private final String rowIdentifierColumnHeader;
    private final Set<String> rowIdentifiers = new LinkedHashSet<String>();
    private final Map<String, Map<String, String>> columnMap = new LinkedHashMap<String, Map<String, String>>();

    public IterativeTableModelBuilder(String rowIdentifierColumnHeader) {
        this.rowIdentifierColumnHeader = rowIdentifierColumnHeader;
    }

    private int findIndexOfIdentifierColumn(DatasetFileLines lines) {
        int idx = 0;
        String[] stringArray = lines.getHeaderLabels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String columnHeader = stringArray[n2];
            if (this.isIdentifierColumn(columnHeader)) {
                return idx;
            }
            ++idx;
            ++n2;
        }
        return -1;
    }

    private boolean isIdentifierColumn(String columnHeader) {
        return this.rowIdentifierColumnHeader.equals(columnHeader);
    }

    public void addFile(DatasetFileLines lines) {
        int colIndexOfRowId = this.findIndexOfIdentifierColumn(lines);
        if (colIndexOfRowId < 0) {
            operationLog.warn("Skip file '" + lines.getFile().getPath() + "' as it has no column '" + this.rowIdentifierColumnHeader + "'.");
            return;
        }
        String[] columnHeaders = lines.getHeaderLabels();
        int colIdx = 0;
        String[] stringArray = columnHeaders;
        int n = columnHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String columnHeader = stringArray[n2];
            Map<String, String> column = this.columnMap.get(columnHeader);
            if (column != null && colIdx == colIndexOfRowId) {
                this.addLineToColumn(lines, column, colIdx, colIndexOfRowId);
                ++colIdx;
            } else {
                if (column != null) {
                    columnHeader = String.valueOf(columnHeader) + "X";
                }
                column = new HashMap<String, String>();
                this.columnMap.put(columnHeader, column);
                this.addLineToColumn(lines, column, colIdx, colIndexOfRowId);
                ++colIdx;
            }
            ++n2;
        }
    }

    private void addLineToColumn(DatasetFileLines lines, Map<String, String> column, int colIdx, int colIndexOfRowId) {
        for (String[] line : lines.getDataLines()) {
            String rowId = line[colIndexOfRowId];
            this.rowIdentifiers.add(rowId);
            column.put(rowId, line[colIdx]);
        }
    }

    public TableModel getTableModel() {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        for (Map.Entry<String, Map<String, String>> column : this.columnMap.entrySet()) {
            builder.addHeader(column.getKey());
        }
        for (String rowId : this.rowIdentifiers) {
            ArrayList<ISerializableComparable> rowValues = new ArrayList<ISerializableComparable>(this.columnMap.size());
            for (String header : this.columnMap.keySet()) {
                String valueOrNull = this.columnMap.get(header).get(rowId);
                rowValues.add(TableCellUtil.createTableCell(valueOrNull == null ? "" : valueOrNull));
            }
            builder.addRow(rowValues);
        }
        return builder.getTableModel();
    }
}

