/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DebugPanelManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IMainPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.MainPagePanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.MainTabPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TopMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SimpleModeHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.ViewMode;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.mvc.View;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Viewport;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

final class AppView
extends View {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private Viewport viewport;
    private IMainPanel mainPanel;
    private ComponentProvider componentProvider;

    AppView(Controller controller, CommonViewContext viewContext) {
        super(controller);
        this.viewContext = viewContext;
    }

    private final AbstractTabItemFactory getData(AppEvent event) {
        return (AbstractTabItemFactory)event.getData();
    }

    private final void activate(AbstractTabItemFactory tabItemFactory) {
        this.mainPanel.open(tabItemFactory);
    }

    private final void initUI() {
        this.viewport = new Viewport();
        this.viewport.setLayout((Layout)new BorderLayout());
        this.createNorth();
        this.createCenter();
        this.createSouth();
        RootPanel.get().clear();
        RootPanel.get().add((Widget)this.viewport);
    }

    private final void createNorth() {
        LayoutContainer north;
        ViewMode viewMode = this.getViewMode();
        if (viewMode == ViewMode.SIMPLE) {
            north = new SimpleModeHeader(this.viewContext, this.componentProvider);
        } else if (viewMode == ViewMode.NORMAL) {
            north = new TopMenu(this.viewContext, this.componentProvider);
        } else if (viewMode == ViewMode.EMBEDDED || viewMode == ViewMode.GRID) {
            north = null;
        } else {
            throw new IllegalStateException("Unknown view mode " + (Object)((Object)viewMode));
        }
        if (north != null) {
            BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.NORTH, 30.0f);
            this.viewport.add((Widget)north, (LayoutData)data);
        }
    }

    private ViewMode getViewMode() {
        return this.viewContext.getModel().getViewMode();
    }

    private final void createCenter() {
        this.mainPanel = AppView.createMainPanel(this.viewContext);
        this.componentProvider.setMainPanel(this.mainPanel);
        BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.CENTER);
        this.viewport.add(this.mainPanel.asWidget(), (LayoutData)data);
    }

    private final void createSouth() {
        if (this.viewContext.isDebuggingEnabled()) {
            BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.SOUTH, 200.0f);
            data.setSplit(true);
            ContentPanel panel = new ContentPanel();
            panel.setScrollMode(Style.Scroll.AUTO);
            panel.setHeaderVisible(false);
            panel.add(DebugPanelManager.createDebugPanel());
            this.viewport.add((Widget)panel, (LayoutData)data);
        }
    }

    protected final void initialize() {
        this.componentProvider = new ComponentProvider(this.viewContext);
    }

    protected final void handleEvent(AppEvent event) {
        if (event.getType() == AppEvents.INIT) {
            this.initUI();
        } else if (event.getType() == AppEvents.NAVI_EVENT) {
            this.activate(this.getData(event));
        }
    }

    private static IMainPanel createMainPanel(IViewContext<ICommonClientServiceAsync> viewContext) {
        if (viewContext.isSimpleOrEmbeddedMode()) {
            return new MainPagePanel(viewContext);
        }
        return new MainTabPanel(viewContext);
    }
}

