/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.HtmlPage;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.LoginPanelAutofill;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.LoginWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

final class LoginPage
extends VerticalPanel {
    private static final int CELL_SPACING = 20;

    LoginPage(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.setSpacing(20);
        this.setWidth("100%");
        this.setHeight("100%");
        this.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        final Widget loginPanel = this.createLoginPanel(viewContext);
        Widget logo = this.createLogo(viewContext);
        final Widget footerPanel = this.createFooter(viewContext);
        Element openbisInstanceElement = Document.get().getElementById("openbis_instance");
        HTML welcomePanel = openbisInstanceElement != null ? HTML.wrap((Element)openbisInstanceElement) : new HTML(viewContext.getMessage("openbis_instance", new Date()));
        welcomePanel.setStyleName("login-welcome-text");
        CellPanel northPanel = LoginPage.createNorthPanel();
        HorizontalPanel topPanel = new HorizontalPanel();
        northPanel.add((Widget)topPanel);
        northPanel.add(logo);
        northPanel.add((Widget)welcomePanel);
        this.add((Widget)this.getBannersPage());
        this.add((Widget)northPanel);
        viewContext.getCommonService().getDisabledText((AsyncCallback<String>)new AbstractAsyncCallback<String>(viewContext){

            @Override
            protected void process(String noLogintext) {
                LoginPage.this.add((Widget)(noLogintext == null ? loginPanel : new HTML(noLogintext)));
                LoginPage.this.add(footerPanel);
            }
        });
        this.setCellVerticalAlignment(footerPanel, HasVerticalAlignment.ALIGN_BOTTOM);
    }

    private Widget createLoginPanel(IViewContext<ICommonClientServiceAsync> viewContext) {
        DockPanel loginPanel = new DockPanel();
        if (!GWTUtils.isTesting()) {
            LoginPanelAutofill loginWidget = LoginPanelAutofill.get(viewContext);
            loginPanel.add((Widget)loginWidget, DockPanel.CENTER);
        } else {
            LoginWidget loginWidget = new LoginWidget(viewContext);
            loginPanel.add((Widget)loginWidget, DockPanel.CENTER);
        }
        return loginPanel;
    }

    private Widget createLogo(IViewContext<ICommonClientServiceAsync> viewContext) {
        Image image = new Image(viewContext.getImageBundle().getOpenBISLogo());
        image.setTitle(viewContext.getMessage("openbis_logo_title", new Object[0]));
        Anchor logo = new Anchor(image.getElement().getString(), true, "http://www.cisd.ethz.ch/software/openBIS", "_blank");
        return logo;
    }

    private static final CellPanel createNorthPanel() {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(20);
        return horizontalPanel;
    }

    private Widget createFooter(IViewContext<ICommonClientServiceAsync> viewContext) {
        Element footerElement = Document.get().getElementById("footer");
        if (footerElement != null) {
            return HTML.wrap((Element)footerElement);
        }
        HorizontalPanel footer = new HorizontalPanel();
        HTML html = new HTML("Click <a href='./custom/help.html' target='_blank'>here</a> for help.");
        footer.add((Widget)html);
        return footer;
    }

    private HTML getBannersPage() {
        Element headerElement = Document.get().getElementById("header");
        if (headerElement != null) {
            return HTML.wrap((Element)headerElement);
        }
        HtmlPage html = new HtmlPage("./custom/loginHeader");
        html.setStyleName("login-header");
        return html;
    }
}

