/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AddAuthorizationGroupDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListPermanentDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AuthorizationGroupGrid
extends TypedTableGrid<AuthorizationGroup> {
    public static final String BROWSER_ID = "openbis_authorization-group-browser";
    public static final String GRID_ID = "openbis_authorization-group-browser-grid";
    public static final String ADD_BUTTON_ID = "openbis_authorization-group-browser_add-button";
    public static final String DELETE_BUTTON_ID = "openbis_authorization-group-browser_delete-button";
    public static final String USERS_BUTTON_ID = "openbis_authorization-group-browser_users-button";
    private final IDelegatedAction postRegistrationCallback = this.createRefreshGridAction();

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        AuthorizationGroupGrid grid = new AuthorizationGroupGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private AuthorizationGroupGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.AUTHORIZATION_GROUP_BROWSER_GRID);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button showDetailsButton = this.createSelectedItemButton(this.viewContext.getMessage("button_show_users", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<AuthorizationGroup>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<AuthorizationGroup>> selectedItem, boolean keyPressed) {
                AuthorizationGroupGrid.this.showEntityViewer(selectedItem.getBaseObject(), false, keyPressed);
            }
        });
        showDetailsButton.setId(USERS_BUTTON_ID);
        this.addButton(showDetailsButton);
        Button addAuthorizationGroupButton = new Button(this.viewContext.getMessage("button_add", "Group"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AddAuthorizationGroupDialog dialog = new AddAuthorizationGroupDialog(AuthorizationGroupGrid.this.viewContext, AuthorizationGroupGrid.this.createRefreshGridAction());
                dialog.show();
            }
        });
        addAuthorizationGroupButton.setId(ADD_BUTTON_ID);
        this.addButton(addAuthorizationGroupButton);
        this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<AuthorizationGroup>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<AuthorizationGroup>> selectedItem, boolean keyPressed) {
                AuthorizationGroup authGroup = selectedItem.getBaseObject().getObjectOrNull();
                AuthorizationGroupGrid.this.createEditDialog(authGroup).show();
            }
        }));
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<AuthorizationGroup>> selected, IBrowserGridActionInvoker invoker) {
                ArrayList<AuthorizationGroup> groups = new ArrayList<AuthorizationGroup>();
                for (TableModelRowWithObject<AuthorizationGroup> row : selected) {
                    groups.add(row.getObjectOrNull());
                }
                return new GroupListDeletionConfirmationDialog(AuthorizationGroupGrid.this.viewContext, (List<AuthorizationGroup>)groups, AuthorizationGroupGrid.this.createRefreshCallback(invoker));
            }
        });
        deleteButton.setId(DELETE_BUTTON_ID);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<AuthorizationGroup>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<AuthorizationGroup>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("CODE", this.createInternalLinkCellRenderer());
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AuthorizationGroup>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AuthorizationGroup>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listAuthorizationGroups(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<AuthorizationGroup>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportAuthorizationGroups(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }

    @Override
    protected void showEntityViewer(final TableModelRowWithObject<AuthorizationGroup> group, boolean editMode, boolean inBackground) {
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = PersonGrid.createForAuthorizationGroup(AuthorizationGroupGrid.this.viewContext, (AuthorizationGroup)group.getObjectOrNull());
                return DefaultTabItem.create(this.getTabTitle(), component, AuthorizationGroupGrid.this.viewContext);
            }

            @Override
            public String getId() {
                return PersonGrid.createBrowserId((AuthorizationGroup)group.getObjectOrNull());
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.AUTHORIZATION_GROUPS, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String getTabTitle() {
                return AuthorizationGroupGrid.this.viewContext.getMessage("authorization_group_users", ((AuthorizationGroup)group.getObjectOrNull()).getCode());
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP)};
    }

    private Window createEditDialog(final AuthorizationGroup authGroup) {
        String title = this.viewContext.getMessage("edit_title", "Authorization Group", authGroup.getCode());
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final DescriptionField descriptionField;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.descriptionField = 6.createDescriptionField(AuthorizationGroupGrid.this.viewContext, false);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, authorizationGroup.getDescription());
                this.addField((Widget)this.descriptionField);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                AuthorizationGroupUpdates updates = new AuthorizationGroupUpdates();
                updates.setDescription((String)this.descriptionField.getValue());
                updates.setId(TechId.create(authGroup));
                updates.setVersion(authGroup.getModificationDate());
                ((ICommonClientServiceAsync)AuthorizationGroupGrid.this.viewContext.getService()).updateAuthorizationGroup(updates, registrationCallback);
            }
        };
    }

    private static final class GroupListDeletionConfirmationDialog
    extends AbstractDataListPermanentDeletionConfirmationDialog<AuthorizationGroup> {
        public GroupListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<AuthorizationGroup> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, callback);
        }

        private IViewContext<ICommonClientServiceAsync> getViewContext() {
            return this.viewContext;
        }

        @Override
        protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
            this.getViewContext().getCommonService().deleteAuthorizationGroups(TechId.createList((Collection)this.data), (String)this.reason.getValue(), deletionCallback);
        }

        @Override
        protected String getEntityName() {
            return this.messageProvider.getMessage("authorization_group", new Object[0]);
        }
    }
}

