/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AddPersonToAuthorizationGroupDialog
extends AbstractRegistrationDialog {
    public static final String ID_MULTIPLE_PERSON_RADIO = "multiple-person-rd";
    public static final String ID_MULTIPLE_PERSON_FIELD = "multiple-person-field";
    public static final String ID_SINGLE_PERSON_FIELD = "single-person-field";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final PersonSelectionWidget singlePersonField;
    private final AuthorizationGroup authorizationGroup;
    private final TextArea multiplePersonsField;
    private final Radio singlePersonRadio;
    private final Radio multiplePersonsRadio;

    public AddPersonToAuthorizationGroupDialog(IViewContext<ICommonClientServiceAsync> viewContext, AuthorizationGroup authorizationGroupOrNull, IDelegatedAction postRegistrationCallback) {
        super(viewContext, viewContext.getMessage("add_person_to_authorization_group_title", authorizationGroupOrNull.getCode()), postRegistrationCallback);
        this.viewContext = viewContext;
        this.authorizationGroup = authorizationGroupOrNull;
        RadioGroup radioGroup = new RadioGroup();
        radioGroup.setLabelSeparator("");
        this.multiplePersonsRadio = new Radio();
        this.multiplePersonsRadio.setId(AddPersonToAuthorizationGroupDialog.createId(authorizationGroupOrNull, ID_MULTIPLE_PERSON_RADIO));
        this.multiplePersonsRadio.setBoxLabel(viewContext.getMessage("radio_many_users", new Object[0]));
        this.singlePersonRadio = new Radio();
        this.singlePersonRadio.setBoxLabel(viewContext.getMessage("radio_one_user", new Object[0]));
        this.singlePersonRadio.setValue(Boolean.valueOf(true));
        radioGroup.add(this.singlePersonRadio);
        radioGroup.add(this.multiplePersonsRadio);
        this.addField((Widget)radioGroup);
        this.singlePersonField = new PersonSelectionWidget(viewContext, AddPersonToAuthorizationGroupDialog.createId(authorizationGroupOrNull, ID_SINGLE_PERSON_FIELD));
        FieldUtil.setMandatoryFlag(this.singlePersonField, true);
        this.addField((Widget)this.singlePersonField);
        this.multiplePersonsField = this.createMultiplePersonField(authorizationGroupOrNull);
        this.addField((Widget)this.multiplePersonsField);
        GWTUtils.updateVisibleField(this.singlePersonRadio.getValue(), this.multiplePersonsRadio.getValue(), this.singlePersonField, this.multiplePersonsField);
        radioGroup.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                GWTUtils.updateVisibleField(AddPersonToAuthorizationGroupDialog.this.singlePersonRadio.getValue(), AddPersonToAuthorizationGroupDialog.this.multiplePersonsRadio.getValue(), AddPersonToAuthorizationGroupDialog.this.singlePersonField, AddPersonToAuthorizationGroupDialog.this.multiplePersonsField);
            }
        });
    }

    private TextArea createMultiplePersonField(AuthorizationGroup authorizationGroupOrNull) {
        TextArea field = new TextArea();
        field.setId(AddPersonToAuthorizationGroupDialog.createId(authorizationGroupOrNull, ID_MULTIPLE_PERSON_FIELD));
        field.setHeight("20em");
        field.setWidth(500);
        field.setFieldLabel(this.viewContext.getMessage("persons_ids_label", new Object[0]));
        field.setEmptyText(this.viewContext.getMessage("person_ids_list", new Object[0]));
        FieldUtil.setMandatoryFlag(field, true);
        return field;
    }

    public static final String createId(AuthorizationGroup authorizationGroupOrNull, String suffix) {
        return "openbis__add-person-to-user-group-dialog_" + authorizationGroupOrNull.getId() + "_" + suffix;
    }

    public final List<String> getUserCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.singlePersonRadio.getValue().booleanValue()) {
            String codeOrNull = this.singlePersonField.tryGetSelectedPersonCode();
            if (codeOrNull != null) {
                codes.add(codeOrNull);
            }
        } else {
            String text = (String)this.multiplePersonsField.getValue();
            if (!StringUtils.isBlank(text)) {
                codes.addAll(Arrays.asList(text.split("\n|\r\n|, *")));
            }
        }
        return codes;
    }

    @Override
    protected void register(AsyncCallback<Void> registrationCallback) {
        List<String> personsCodes = this.getUserCodes();
        if (personsCodes.size() > 0) {
            TechId authGroupId = TechId.create(this.authorizationGroup);
            this.viewContext.getService().addPersonsToAuthorizationGroup(authGroupId, personsCodes, registrationCallback);
        } else {
            MessageBox.alert((String)"Info", (String)"No users have been selected.", null);
        }
    }
}

