/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardState;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardStateChangeListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardPage;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardWorkflowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.layout.CardLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Wizard<M extends IWizardDataModel>
extends LayoutContainer
implements IDisposableComponent {
    private final CardLayout layout;
    private final M model;
    private final WizardWorkflowModel workflowModel;
    private final Map<IWizardState, WizardPage<M>> pages = new HashMap<IWizardState, WizardPage<M>>();
    private final Set<WizardPage<M>> visitedPages = new HashSet<WizardPage<M>>();

    public Wizard(M model) {
        this.layout = new CardLayout();
        this.setLayout((Layout)this.layout);
        this.model = model;
        this.workflowModel = model.getWorkflow();
        this.workflowModel.addStateChangeListener(new IWizardStateChangeListener(){

            @Override
            public void stateChanged(IWizardState previousStateOrNull, IWizardState currentStateOrNull) {
                Wizard.this.changePage(previousStateOrNull, currentStateOrNull);
            }
        });
    }

    public M getWizardDataModel() {
        return this.model;
    }

    public void register(WizardPage<M> page) {
        this.pages.put(page.getWizardState(), page);
    }

    public void start() {
        this.workflowModel.nextState();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        for (WizardPage<M> page : this.visitedPages) {
            page.destroy();
        }
    }

    private void changePage(IWizardState previousStateOrNull, IWizardState currentStateOrNull) {
        if (currentStateOrNull != null) {
            WizardPage<M> nextPage = this.pages.get(currentStateOrNull);
            if (nextPage != null) {
                nextPage.activate();
                if (!this.visitedPages.contains(nextPage)) {
                    nextPage.init();
                    this.visitedPages.add(nextPage);
                    this.add((Component)nextPage);
                }
                this.layout.setActiveItem(nextPage);
            }
        } else if (!this.workflowModel.hasNextState(currentStateOrNull)) {
            String message = this.model.finish();
            MessageBox.info((String)"Info", (String)message, null);
            Widget parent = this.getParent();
            if (parent instanceof TabItem) {
                ((TabItem)parent).close();
            }
        }
    }
}

