/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.TextMetrics;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public final class GWTUtils {
    public static final String NONE_LIST_ITEM = "(None)";
    private static boolean testing = false;
    private static final String CONFIRM_EXIT_MSG = "WARNING: By doing this you will in fact leave openBIS!";

    private GWTUtils() {
    }

    public static boolean isTesting() {
        return testing;
    }

    public static void testing() {
        testing = true;
    }

    public static void updatePageTitle(String prefix) {
        String title = String.valueOf(prefix.equals("&nbsp;") ? "" : String.valueOf(prefix) + " - ") + CommonViewContext.ClientStaticState.getPageTitleSuffix();
        com.google.gwt.user.client.Window.setTitle((String)title);
    }

    public static Window createErrorMessageWithDetailsDialog(IMessageProvider messageProvider, String basicMsg, final String detailedMsg) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setLayout((Layout)new FitLayout());
        panel.addText(basicMsg);
        panel.setBorders(false);
        SimpleDialog dialog = new SimpleDialog((Widget)panel, "Error", "Show Details", messageProvider, new Button[0]);
        dialog.setAcceptAction(new IDelegatedAction(){

            @Override
            public void execute() {
                MessageBox.alert((String)"Error Details", (String)detailedMsg, null);
            }
        });
        return dialog;
    }

    public static void setupAutoWidth(final ComboBox<?> comboBox) {
        comboBox.getListView().addListener(Events.Render, (Listener)new Listener<BaseEvent>(){
            private static final int MARGIN = 30;

            public void handleEvent(BaseEvent be) {
                comboBox.setMinListWidth(30 + this.computeMaxLabelWidth(comboBox.getListView().el()));
            }

            public int computeMaxLabelWidth(El el) {
                TextMetrics metrics = TextMetrics.get();
                metrics.bind(el);
                String displayField = comboBox.getDisplayField();
                int maxLabelWidth = 0;
                for (ModelData model : comboBox.getStore().getModels()) {
                    String displayedString = model.get(displayField).toString();
                    maxLabelWidth = Math.max(maxLabelWidth, metrics.getWidth(displayedString));
                }
                return Math.min(com.google.gwt.user.client.Window.getClientWidth() / 2, maxLabelWidth);
            }
        });
    }

    public static void executeDelayed(IDelegatedAction delegatedAction) {
        if (!GWTUtils.isTesting()) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)delegatedAction);
        } else {
            delegatedAction.execute();
        }
    }

    public static final void setSelectedItem(ListBox listBox, String value) {
        assert (listBox != null) : "Unspecified list box.";
        assert (value != null) : "Unspecified value.";
        int index = 0;
        while (index < listBox.getItemCount()) {
            if (listBox.getItemText(index).equals(value)) {
                listBox.setSelectedIndex(index);
                return;
            }
            ++index;
        }
        throw new IllegalArgumentException("Given value '" + value + "' not found in given list box.");
    }

    public static final <T extends ModelData> void setSelectedItem(ComboBox<T> comboBox, String property, String value) {
        assert (comboBox != null) : "Unspecified combo box.";
        assert (property != null) : "Unspecified model property.";
        assert (value != null) : "Unspecified model property value.";
        ListStore store = comboBox.getStore();
        List list = store.findModels(property, (Object)value);
        if (list.size() == 0) {
            ArrayList<Object> possibleValues = new ArrayList<Object>();
            for (ModelData t : store.getModels()) {
                possibleValues.add(t.get(property));
            }
            throw new IllegalArgumentException("Given value '" + value + "' for property '" + property + "' not found in the combo box. Possible values are: '" + possibleValues + "'.");
        }
        ArrayList<ModelData> selection = new ArrayList<ModelData>();
        selection.add((ModelData)list.get(0));
        comboBox.setSelection(selection);
    }

    public static <T extends ModelData> void autoselect(ComboBox<T> combo) {
        GWTUtils.autoselect(combo, true);
    }

    public static <T extends ModelData> void autoselect(ComboBox<T> combo, boolean onlyIfEmpty) {
        if (onlyIfEmpty && combo.getValue() != null) {
            return;
        }
        List models = combo.getStore().getModels();
        if (models.size() > 0) {
            combo.setValue((ModelData)models.get(0));
        }
    }

    public static final <T extends ModelData> boolean isPropertyNotInList(ComboBox<T> comboBox, String property, String value) {
        assert (comboBox != null) : "Unspecified combo box.";
        assert (property != null) : "Unspecified model property.";
        assert (value != null) : "Unspecified model property value.";
        ListStore store = comboBox.getStore();
        List list = store.findModels(property, (Object)value);
        return list.size() == 0;
    }

    public static final <T extends ModelData> void unselect(ComboBox<T> comboBox) {
        assert (comboBox != null) : "Unspecified comboBox.";
        comboBox.setValue(null);
    }

    public static final void setSelectedItem(TreeGrid<ModelData> tree, String property, String value) {
        ModelData model = GWTUtils.tryFindModel(tree.getTreeStore().getAllItems(), property, value);
        if (model != null) {
            GridSelectionModel selectionModel = tree.getSelectionModel();
            selectionModel.select(model, false);
            int row = tree.getStore().indexOf(model);
            tree.getView().ensureVisible(row, 0, false);
        }
    }

    public static void setToolTip(Component component, String textOrNull) {
        ToolTipConfig config = null;
        if (textOrNull != null) {
            String preparedText = GWTUtils.translateToHtmlLineBreaks(textOrNull);
            config = new ToolTipConfig(preparedText);
        }
        component.setToolTip(config);
    }

    public static void setToolTip(Component component, ToolTipConfig config) {
        String textOrNull = config.getText();
        if (textOrNull != null) {
            String preparedText = GWTUtils.translateToHtmlLineBreaks(textOrNull);
            config.setText(preparedText);
        }
        component.setToolTip(config);
    }

    public static String translateToHtmlLineBreaks(String textOrNull) {
        return textOrNull != null ? textOrNull.replace("\n", "<br>") : null;
    }

    public static final ModelData tryFindModel(List<ModelData> models, String property, String value) {
        assert (models != null) : "Unspecified models.";
        assert (property != null) : "Unspecified model property.";
        assert (value != null) : "Unspecified model property value.";
        for (ModelData model : models) {
            Object val;
            if (model == null || (val = model.get(property)) != value && (val == null || !val.equals(value))) continue;
            return model;
        }
        return null;
    }

    public static final <T extends ModelData> T tryGetSingleSelectedModel(ComboBox<T> comboBox) {
        assert (comboBox != null) : "Unspecified combo box.";
        List selection = comboBox.getSelection();
        int size = selection.size();
        if (size > 0) {
            assert (size == 1) : "Only one item must be selected.";
            return (T)((ModelData)selection.get(0));
        }
        return null;
    }

    public static final <T extends ModelData, O> O tryGetSingleSelectedProperty(ComboBox<T> comboBox, String propertyName) {
        T selectedModel = GWTUtils.tryGetSingleSelectedModel(comboBox);
        if (selectedModel == null) {
            return null;
        }
        return (O)selectedModel.get(propertyName);
    }

    public static final <T extends ModelData> String tryGetSingleSelectedCode(ComboBox<T> comboBox) {
        return (String)GWTUtils.tryGetSingleSelectedProperty(comboBox, "code");
    }

    public static final <T extends ModelData, O> O tryGetSingleSelected(ComboBox<T> comboBox) {
        return GWTUtils.tryGetSingleSelectedProperty(comboBox, "object");
    }

    public static final String getBaseIndexURL() {
        return String.valueOf(GWT.getModuleBaseURL()) + "index.html";
    }

    public static final void updateVisibleField(boolean firstOn, boolean secondOn, Field<?> firstField, Field<?> secondField) {
        if (firstOn ^ secondOn) {
            firstField.setEnabled(firstOn);
            firstField.setVisible(firstOn);
            secondField.setEnabled(secondOn);
            secondField.setVisible(secondOn);
            if (firstOn) {
                firstField.validate();
                secondField.clearInvalid();
            } else {
                firstField.clearInvalid();
                secondField.validate();
            }
        }
    }

    public static final String escapeToFormId(String original) {
        return original.toLowerCase().replace(".", "-DOT-").replace("_", "-UNDERSCORE-").replace("$", "-DOLLAR-").replace("/", "-SLASH-").replace(":", "-COLON-");
    }

    public static final void setConfirmExitMessage() {
        GWTUtils.setConfirmExitMessage(CONFIRM_EXIT_MSG);
    }

    public static final void removeConfirmExitMessage() {
        GWTUtils.setConfirmExitMessage(null);
    }

    private static final void setConfirmExitMessage(final String msgOrNull) {
        com.google.gwt.user.client.Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                event.setMessage(msgOrNull);
            }
        });
    }

    public static final String getParamString() {
        return Window.Location.getQueryString();
    }

    public static final boolean isDeployed() {
        return GWT.isScript();
    }

    public static final void displayInfo(String title) {
        GWTUtils.displayInfo(title, "", DisplayInfoTime.MEDIUM);
    }

    public static final void displayInfo(String title, DisplayInfoTime time) {
        GWTUtils.displayInfo(title, "", time.getTime());
    }

    public static final void displayInfo(String title, String text) {
        GWTUtils.displayInfo(title, text, DisplayInfoTime.MEDIUM);
    }

    public static final void displayInfo(String title, String text, DisplayInfoTime time) {
        GWTUtils.displayInfo(title, text, time.getTime());
    }

    private static final void displayInfo(String title, String text, int displayTime) {
        InfoConfig config = new InfoConfig(title, text);
        config.display = displayTime;
        Info.display((InfoConfig)config);
    }

    public static final native String getTooltipTemplate(String var0, String var1);

    public static enum DisplayInfoTime {
        SHORT(2500),
        MEDIUM(5000),
        LONG(10000);

        private final int time;

        private DisplayInfoTime(int time) {
            this.time = time;
        }

        public int getTime() {
            return this.time;
        }
    }
}

