/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.client.web.server.Message;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

@Controller
@RequestMapping(value={"/upload", "/openbis/upload"})
public final class UploadServiceServlet
extends AbstractCommandController {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, UploadServiceServlet.class);
    ISessionFilesSetter sessionFilesSetter;
    @Resource(name="session-manager")
    protected IOpenBisSessionManager sessionManager;

    @Private
    UploadServiceServlet(ISessionFilesSetter sessionFilesSetter) {
        super(UploadedFilesBean.class);
        this.setSynchronizeOnSession(true);
        this.setRequireSession(false);
        this.sessionFilesSetter = sessionFilesSetter;
    }

    public UploadServiceServlet() {
        this(new SessionFilesSetter());
    }

    private static final Iterator<String> cast(Iterator iterator) {
        return iterator;
    }

    private final void sendResponse(HttpServletResponse response, String textOrNull) {
        response.setContentType("text/html");
        response.setStatus(200);
        if (textOrNull != null) {
            try {
                response.getWriter().write(textOrNull);
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            return super.handleRequestInternal(request, response);
        }
        catch (Throwable th) {
            operationLog.error("Error handling request.", th);
            if (th instanceof Error) {
                throw (Error)th;
            }
            String msg = th.getMessage();
            if (StringUtils.isBlank((String)msg)) {
                msg = String.format("Error handling request: %s.", th.getClass().getName());
            }
            this.sendResponse(response, Message.createErrorMessage(msg).toXml());
            return null;
        }
    }

    protected Session getSession(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        return (Session)this.sessionManager.getSession(sessionToken);
    }

    protected final ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (request instanceof MultipartHttpServletRequest) {
            Session sessionFromToken;
            String tokenBeingUsed;
            Session sessionFromToken2;
            HttpSession session = request.getSession(false);
            String sessionToken = request.getParameter("sessionID");
            if (session == null && sessionToken != null && !sessionToken.isEmpty() && (sessionFromToken2 = this.getSession(sessionToken)) != null) {
                session = request.getSession();
                session.setAttribute("openbis-session-token", (Object)sessionFromToken2.getSessionToken());
            }
            if (session != null && sessionToken != null && !sessionToken.isEmpty() && !sessionToken.equals(tokenBeingUsed = (String)session.getAttribute("openbis-session-token")) && (sessionFromToken = this.getSession(sessionToken)) != null) {
                session.setAttribute("openbis-session-token", (Object)sessionFromToken.getSessionToken());
            }
            if (session == null) {
                response.setStatus(500);
                throw new HttpSessionRequiredException("Pre-existing session required but none found");
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            String sessionKeysNumberParameter = request.getParameter("sessionKeysNumber");
            if (sessionKeysNumberParameter == null || Integer.parseInt(sessionKeysNumberParameter) < 1) {
                throw new ServletException("No form field 'sessionKeysNumber' could be found in the transmitted form.");
            }
            boolean atLeastOneFileUploaded = false;
            for (String sessionKey : UploadServiceServlet.extractSessionKeys(request, sessionKeysNumberParameter)) {
                boolean fileExtracted = this.sessionFilesSetter.addFilesToSession(session, multipartRequest, sessionKey);
                boolean bl = atLeastOneFileUploaded = atLeastOneFileUploaded || fileExtracted;
            }
            if (!atLeastOneFileUploaded) {
                throw UserFailureException.fromTemplate("No file has been uploaded or the chosen files have no content.", new Object[0]);
            }
            this.sendResponse(response, null);
        }
        return null;
    }

    private static List<String> extractSessionKeys(HttpServletRequest request, String sessionKeysNumberParameter) throws ServletException {
        ArrayList<String> sessionKeys = new ArrayList<String>();
        int i = 0;
        while (i < Integer.parseInt(sessionKeysNumberParameter)) {
            String sessionKey = StringUtils.trim((String)request.getParameter("sessionKey_" + i));
            if (StringUtils.isBlank((String)sessionKey)) {
                throw new ServletException("No field 'sessionKey_" + i + "' could be found in the transmitted form.");
            }
            sessionKeys.add(sessionKey);
            ++i;
        }
        return sessionKeys;
    }

    @Private
    static interface ISessionFilesSetter {
        public boolean addFilesToSession(HttpSession var1, MultipartHttpServletRequest var2, String var3);
    }

    @Private
    static class SessionFilesSetter
    implements ISessionFilesSetter {
        SessionFilesSetter() {
        }

        @Override
        public boolean addFilesToSession(HttpSession session, MultipartHttpServletRequest multipartRequest, String sessionKey) {
            return this.addFilesToSessionUsingBean(session, multipartRequest, sessionKey, new UploadedFilesBean());
        }

        @Private
        boolean addFilesToSessionUsingBean(HttpSession session, MultipartHttpServletRequest multipartRequest, String sessionKey, UploadedFilesBean uploadedFiles) {
            assert (!StringUtils.isBlank((String)sessionKey));
            boolean fileUploaded = false;
            Iterator iterator = UploadServiceServlet.cast(multipartRequest.getFileNames());
            while (iterator.hasNext()) {
                MultipartFile multipartFile;
                String fileName = (String)iterator.next();
                if (!fileName.startsWith(sessionKey) || (multipartFile = multipartRequest.getFile(fileName)).isEmpty()) continue;
                uploadedFiles.addMultipartFile(multipartFile);
                fileUploaded = true;
            }
            session.setAttribute(sessionKey, (Object)uploadedFiles);
            return fileUploaded;
        }
    }
}

