/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadInterceptor;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadLogConfiguration;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadLogger;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.RootClassFilter;

public class LongRunningThreadAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    public static final int ORDER = Integer.MIN_VALUE;

    LongRunningThreadAdvisor() {
        super(LongRunningThreadAdvisor.createPointcut(), LongRunningThreadAdvisor.createAdvice());
        this.setOrder(Integer.MIN_VALUE);
    }

    private static final Advice createAdvice() {
        LongRunningThreadInterceptor advice = new LongRunningThreadInterceptor();
        new Thread(new LongRunningThreadLogger(advice, LongRunningThreadLogConfiguration.getInstance())).start();
        return advice;
    }

    private static final Pointcut createPointcut() {
        return new AllServerMethodsPointcut();
    }

    private static class AllServerMethodsPointcut
    implements Pointcut {
        private AllServerMethodsPointcut() {
        }

        public MethodMatcher getMethodMatcher() {
            return MethodMatcher.TRUE;
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(IServer.class);
        }
    }
}

