/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.ISessionFactory;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import org.apache.log4j.Logger;

public final class SessionFactory
implements ISessionFactory<Session> {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SessionFactory.class);
    private final IDataStoreDAO datastoreDAO;
    private final IDataStoreServiceFactory dssFactory;

    public SessionFactory() {
        this(null, null);
    }

    public SessionFactory(IDAOFactory daoFactory, IDataStoreServiceFactory dssFactory) {
        this.datastoreDAO = daoFactory != null ? daoFactory.getDataStoreDAO() : null;
        this.dssFactory = dssFactory;
    }

    @Override
    public final Session create(final String sessionToken, String userName, Principal principal, String remoteHost, long sessionStart, int expirationTime) {
        Session session = new Session(userName, sessionToken, principal, remoteHost, sessionStart, expirationTime);
        if (this.datastoreDAO != null && this.dssFactory != null) {
            session.addCleanupListener(new Session.ISessionCleaner(){

                @Override
                public void cleanup() {
                    SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, SessionFactory.this.datastoreDAO, SessionFactory.this.dssFactory);
                }
            });
        }
        return session;
    }

    public static void cleanUpSessionOnDataStoreServers(String sessionToken, IDataStoreDAO datastoreDAO, IDataStoreServiceFactory dssFactory) {
        for (DataStorePE datastore : datastoreDAO.listDataStores()) {
            String remoteUrl = datastore.getRemoteUrl();
            if (!StringUtils.isBlank(remoteUrl)) {
                dssFactory.createMonitored(remoteUrl, LogLevel.WARN).cleanupSession(sessionToken);
                continue;
            }
            operationLog.warn("datastore remoteUrl of datastore " + datastore.getCode() + " is empty - skipping DSS session cleanup.");
        }
    }
}

