/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1.sort;

import ch.systemsx.cisd.openbis.generic.server.business.search.sort.IEntitySearchResult;
import ch.systemsx.cisd.openbis.generic.server.business.search.sort.SearchResultSorterByScore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SampleSearchResultSorter {
    public List<Sample> sort(List<Sample> samples, DetailedSearchCriteria criteria) {
        ArrayList<SampleSearchResult> samplesToSort = new ArrayList<SampleSearchResult>();
        for (Sample sample : samples) {
            samplesToSort.add(new SampleSearchResult(sample));
        }
        SearchResultSorterByScore sort = new SearchResultSorterByScore();
        sort.sort(samplesToSort, criteria);
        ArrayList<Sample> sortedSamples = new ArrayList<Sample>();
        for (SampleSearchResult sampleSearchResult : samplesToSort) {
            sortedSamples.add(sampleSearchResult.getSample());
        }
        return sortedSamples;
    }

    private class SampleSearchResult
    implements IEntitySearchResult {
        private Sample sample;

        public SampleSearchResult(Sample sample) {
            this.sample = sample;
        }

        public Sample getSample() {
            return this.sample;
        }

        @Override
        public String getCode() {
            return this.sample.getCode();
        }

        @Override
        public Map<String, String> getProperties() {
            if (this.sample.getRetrievedFetchOptions().contains(SampleFetchOption.PROPERTIES)) {
                return this.sample.getProperties();
            }
            return Collections.emptyMap();
        }

        @Override
        public String getTypeCode() {
            return this.sample.getSampleTypeCode();
        }

        public String toString() {
            return this.sample.getCode();
        }
    }
}

