/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.Argument;
import ch.systemsx.cisd.openbis.generic.server.authorization.CapabilityMap;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.PredicateExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.PredicateFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public final class DefaultAccessController
implements IAccessController {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DefaultAccessController.class);
    @Private
    static final String MATCHING_ROLE_NOT_FOUND_TEMPLATE = "None of method roles '%s' could be found in roles of user '%s'.";
    @Private
    static final String USER_ROLE_ASSIGNMENTS_NOT_FOUND_TEMPLATE = "No role assignments could be found for user '%s'.";
    @Private
    static final String METHOD_ROLES_NOT_FOUND_TEMPLATE = "No roles have been found for method '%s'.";
    private final Map<Method, Set<RoleWithHierarchy>> methodRolesCache = new HashMap<Method, Set<RoleWithHierarchy>>();
    private final CapabilityMap capabilities = new CapabilityMap(new File("etc/capabilities"));
    private PredicateExecutor predicateExecutor = new PredicateExecutor();

    public DefaultAccessController(IAuthorizationDAOFactory daoFactory) {
        this.predicateExecutor.setPredicateFactory(new PredicateFactory());
        this.predicateExecutor.setDAOFactory(daoFactory);
    }

    public static final List<RoleWithIdentifier> getUserRoles(PersonPE person) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        return DefaultAccessController.extractRolesWithIdentifiers(roleAssignments);
    }

    private static List<RoleWithIdentifier> extractRolesWithIdentifiers(Set<RoleAssignmentPE> roleAssignments) {
        ArrayList<RoleWithIdentifier> roles = new ArrayList<RoleWithIdentifier>();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            roles.add(RoleWithIdentifier.createRole(roleAssignment));
        }
        return roles;
    }

    private static final void logTimeTaken(StopWatch stopWatch, Method method) {
        stopWatch.stop();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Controlling access to method '%s' took %s", MethodUtils.describeMethod(method), stopWatch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RoleWithHierarchy> getMethodRoles(Method method) {
        Map<Method, Set<RoleWithHierarchy>> map = this.methodRolesCache;
        synchronized (map) {
            Set<RoleWithHierarchy> roles = this.methodRolesCache.get(method);
            if (roles == null) {
                roles = new LinkedHashSet<RoleWithHierarchy>();
                Collection<RoleWithHierarchy> rootRoles = this.capabilities.tryGetRoles(method);
                if (rootRoles != null) {
                    for (RoleWithHierarchy role : rootRoles) {
                        roles.addAll(role.getRoles());
                    }
                } else {
                    RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
                    if (rolesAllowed != null) {
                        RoleWithHierarchy[] roleWithHierarchyArray = rolesAllowed.value();
                        int n = roleWithHierarchyArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RoleWithHierarchy role = roleWithHierarchyArray[n2];
                            roles.addAll(role.getRoles());
                            ++n2;
                        }
                    }
                }
                this.methodRolesCache.put(method, roles);
            }
            return roles;
        }
    }

    @Override
    public final Status isAuthorized(IAuthSession session, Method method, Argument<?>[] arguments) throws UserFailureException {
        assert (session != null) : "Unspecified session";
        assert (method != null) : "Unspecified method";
        assert (arguments != null) : "Unspecified method arguments";
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Set<RoleWithHierarchy> methodRoles = this.getMethodRoles(method);
            if (methodRoles.size() == 0) {
                String msg = String.format(METHOD_ROLES_NOT_FOUND_TEMPLATE, MethodUtils.describeMethod(method));
                Status status = Status.createError(msg);
                return status;
            }
            PersonPE person = session.tryGetPerson();
            if (person == null || person.getAllPersonRoles().size() == 0) {
                String msg = String.format(USER_ROLE_ASSIGNMENTS_NOT_FOUND_TEMPLATE, session.getUserName());
                Status status = Status.createError(msg);
                return status;
            }
            List<RoleWithIdentifier> userRoles = DefaultAccessController.getUserRoles(person);
            DefaultAccessController.retainMatchingRoleWithIdentifiers(userRoles, methodRoles);
            if (userRoles.size() == 0) {
                String msg = String.format(MATCHING_ROLE_NOT_FOUND_TEMPLATE, methodRoles, session.getUserName());
                Status status = Status.createError(msg);
                return status;
            }
            if (arguments.length > 0) {
                Argument<?>[] argumentArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Argument<?> argument = argumentArray[n2];
                    Status status = this.predicateExecutor.evaluate(person, userRoles, argument);
                    if (!status.getFlag().equals((Object)StatusFlag.OK)) {
                        Status status2 = status;
                        return status2;
                    }
                    ++n2;
                }
            }
            Status status = Status.OK;
            return status;
        }
        finally {
            DefaultAccessController.logTimeTaken(stopWatch, method);
        }
    }

    public static List<RoleWithIdentifier> retainMatchingRoleWithIdentifiers(List<RoleWithIdentifier> userRoles, Set<RoleWithHierarchy> methodRoles) {
        Iterator<RoleWithIdentifier> it = userRoles.iterator();
        while (it.hasNext()) {
            RoleWithIdentifier roleWithIdentifier = it.next();
            if (methodRoles.contains(roleWithIdentifier.getRole())) continue;
            it.remove();
        }
        return userRoles;
    }
}

