/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;
import org.springframework.dao.DataAccessException;

abstract class AbstractPredicate<T>
implements IPredicate<T> {
    AbstractPredicate() {
    }

    public abstract String getCandidateDescription();

    protected abstract Status doEvaluation(PersonPE var1, List<RoleWithIdentifier> var2, T var3);

    protected boolean isNullValueAllowed() {
        return false;
    }

    public static Status hasInstanceWritePermissions(PersonPE aPerson, List<RoleWithIdentifier> allowedRoles) {
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleCode roleCode;
            if (role.getRoleLevel() != RoleWithHierarchy.RoleLevel.INSTANCE || !RoleWithHierarchy.RoleCode.ADMIN.equals((Object)(roleCode = role.getRole().getRoleCode())) && !RoleWithHierarchy.RoleCode.ETL_SERVER.equals((Object)roleCode)) continue;
            return Status.OK;
        }
        return Status.createError(false, "None of method roles '[INSTANCE_ETL_SERVER, INSTANCE_ADMIN]' could be found in roles of user '" + aPerson.getUserId() + "'.");
    }

    public static Status hasInstanceReadPermissions(PersonPE aPerson, List<RoleWithIdentifier> allowedRoles) {
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleCode roleCode;
            if (role.getRoleLevel() != RoleWithHierarchy.RoleLevel.INSTANCE || !RoleWithHierarchy.RoleCode.ADMIN.equals((Object)(roleCode = role.getRole().getRoleCode())) && !RoleWithHierarchy.RoleCode.ETL_SERVER.equals((Object)roleCode) && !RoleWithHierarchy.RoleCode.OBSERVER.equals((Object)roleCode)) continue;
            return Status.OK;
        }
        return Status.createError(false, "None of method roles '[INSTANCE_ETL_SERVER, INSTANCE_ADMIN, INSTANCE_OBSERVER]' could be found in roles of user '" + aPerson.getUserId() + "'.");
    }

    @Override
    public final Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T valueOrNull) {
        assert (person != null) : "Unspecified person";
        assert (allowedRoles != null) : "Unspecified allowed roles";
        if (valueOrNull == null && !this.isNullValueAllowed()) {
            throw UserFailureException.fromTemplate("No %s specified.", this.getCandidateDescription());
        }
        try {
            return this.doEvaluation(person, allowedRoles, valueOrNull);
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMessage(), ex);
        }
    }
}

