/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.util.ArrayList;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class DataSetUpdatesCollectionPredicate
extends AbstractPredicate<List<? extends DataSetUpdatesDTO>> {
    private final AbstractTechIdCollectionPredicate.DataSetTechIdCollectionPredicate dataSetTechIdCollectionPredicate = new AbstractTechIdCollectionPredicate.DataSetTechIdCollectionPredicate();
    private final SpaceIdentifierPredicate spacePredicate;
    private final SampleOwnerIdentifierCollectionPredicate sampleCollectionPredicate = new SampleOwnerIdentifierCollectionPredicate();

    public DataSetUpdatesCollectionPredicate() {
        this.spacePredicate = new SpaceIdentifierPredicate();
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataSetTechIdCollectionPredicate.init(provider);
        this.sampleCollectionPredicate.init(provider);
        this.spacePredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "data set updates collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<? extends DataSetUpdatesDTO> value) {
        if (DataSetUpdatesCollectionPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        IServiceConversationProgressListener progressListener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        ArrayList<SampleOwnerIdentifier> sampleIdentifiers = new ArrayList<SampleOwnerIdentifier>();
        int index = 0;
        for (DataSetUpdatesDTO dataSetUpdatesDTO : value) {
            Status result;
            techIds.add(dataSetUpdatesDTO.getDatasetId());
            ExperimentIdentifier experimentIdentifier = dataSetUpdatesDTO.getExperimentIdentifierOrNull();
            if (experimentIdentifier != null && !(result = this.spacePredicate.doEvaluation(person, allowedRoles, experimentIdentifier)).isOK()) {
                return result;
            }
            SampleIdentifier sampleIdentifier = dataSetUpdatesDTO.getSampleIdentifierOrNull();
            if (sampleIdentifier != null) {
                sampleIdentifiers.add(sampleIdentifier);
            }
            progressListener.update("authorizeDatasetUpdates", value.size(), ++index);
        }
        Status status = this.dataSetTechIdCollectionPredicate.doEvaluation(person, allowedRoles, (List<TechId>)techIds);
        if (!status.isOK()) {
            return status;
        }
        return this.sampleCollectionPredicate.doEvaluation(person, allowedRoles, (List<SampleOwnerIdentifier>)sampleIdentifiers);
    }
}

