/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import java.util.List;

public final class DatabaseInstanceIdentifierPredicate
extends AbstractDatabaseInstancePredicate<DatabaseInstanceIdentifier> {
    private final boolean isReadAccess;

    public DatabaseInstanceIdentifierPredicate(boolean isReadAccess) {
        this.isReadAccess = isReadAccess;
    }

    private static final boolean isMatching(List<RoleWithIdentifier> allowedRoles, String databaseInstanceUUID, boolean isReadAccess) {
        if (isReadAccess) {
            return true;
        }
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleLevel roleGroup = role.getRoleLevel();
            if (!roleGroup.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE) || !role.getAssignedDatabaseInstance().getUuid().equals(databaseInstanceUUID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getCandidateDescription() {
        return "database instance identifier";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, DatabaseInstanceIdentifier databaseInstanceIdentifier) {
        assert (this.initialized) : "Predicate has not been initialized";
        DatabaseInstancePE databaseInstance = this.getDatabaseInstance(databaseInstanceIdentifier);
        boolean matching = DatabaseInstanceIdentifierPredicate.isMatching(allowedRoles, databaseInstance.getUuid(), this.isReadAccess);
        if (matching) {
            return Status.OK;
        }
        String userId = person.getUserId();
        return Status.createError(this.createErrorMsg(databaseInstance, userId));
    }

    private String createErrorMsg(DatabaseInstancePE databaseInstance, String userId) {
        String accessType = this.isReadAccess ? "read from" : "modify";
        return String.format("User '%s' does not have enough privileges to %s database instance '%s'.", userId, accessType, databaseInstance.getCode());
    }
}

