/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public abstract class DelegatedPredicate<P, T>
extends AbstractPredicate<T> {
    private final IPredicate<P> delegate;
    boolean initialized;
    protected IAuthorizationDataProvider authorizationDataProvider;

    public DelegatedPredicate(IPredicate<P> delegate) {
        this.delegate = delegate;
    }

    public abstract P tryConvert(T var1);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        assert (!this.initialized);
        this.authorizationDataProvider = provider;
        this.delegate.init(provider);
        this.initialized = true;
    }

    @Override
    public final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, T value) {
        P convertedValue = this.tryConvert(value);
        if (convertedValue != null) {
            return this.delegate.evaluate(person, allowedRoles, convertedValue);
        }
        return Status.OK;
    }
}

