/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.ExperimentIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.ExperimentPermIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.ExperimentTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class ExperimentIdPredicate
extends AbstractExperimentPredicate<IExperimentId> {
    @Override
    public String getCandidateDescription() {
        return "experiment id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, IExperimentId experimentId) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.experimentTechIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.experimentPermIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.experimentAugmentedCodePredicate.initialized) : "Predicate has not been initialized";
        if (experimentId instanceof ExperimentIdentifierId) {
            ExperimentIdentifierId identifierId = (ExperimentIdentifierId)experimentId;
            return this.experimentAugmentedCodePredicate.doEvaluation(person, allowedRoles, identifierId.getIdentifier());
        }
        if (experimentId instanceof ExperimentPermIdId) {
            ExperimentPermIdId permIdId = (ExperimentPermIdId)experimentId;
            return this.experimentPermIdPredicate.doEvaluation(person, allowedRoles, new PermId(permIdId.getPermId()));
        }
        if (experimentId instanceof ExperimentTechIdId) {
            ExperimentTechIdId techIdId = (ExperimentTechIdId)experimentId;
            return this.experimentTechIdPredicate.doEvaluation(person, allowedRoles, new TechId(techIdId.getTechId()));
        }
        return Status.createError("Unsupported experiment id: " + experimentId);
    }
}

