/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.util.List;

public final class NewSamplesWithTypePredicate
extends AbstractPredicate<NewSamplesWithTypes> {
    private final IPredicate<SampleOwnerIdentifier> delegate;

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.delegate.init(provider);
    }

    @Override
    public final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewSamplesWithTypes value) {
        Status s = Status.OK;
        for (NewSample sample : value.getNewEntities()) {
            SampleIdentifier identifier = SampleIdentifierFactory.parse(sample.getIdentifier());
            s = this.delegate.evaluate(person, allowedRoles, identifier);
            if (s.equals(Status.OK)) continue;
            return s;
        }
        return s;
    }

    @Deprecated
    NewSamplesWithTypePredicate(IPredicate<SampleOwnerIdentifier> delegate) {
        this.delegate = delegate;
    }

    public NewSamplesWithTypePredicate() {
        this.delegate = new SampleOwnerIdentifierPredicate(false);
    }

    @Override
    public final String getCandidateDescription() {
        return "new sample";
    }
}

