/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DeletionTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class RevertDeletionPredicate
extends AbstractPredicate<List<TechId>> {
    private IAuthorizationDataProvider provider;
    private DeletionTechIdCollectionPredicate deletionTechIdCollectionPredicate = new DeletionTechIdCollectionPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.provider = provider;
        this.deletionTechIdCollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "revert deletion technical id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> value) {
        if (RevertDeletionPredicate.isInstanceAdmin(person)) {
            return Status.OK;
        }
        List<DeletionPE> deletions = this.provider.getDeletions(value);
        ArrayList<TechId> deletionsToCheck = new ArrayList<TechId>();
        for (DeletionPE deletion : deletions) {
            if (this.isRegistrator(person, deletion)) continue;
            deletionsToCheck.add(new TechId(deletion.getId()));
        }
        if (deletionsToCheck.size() > 0) {
            return this.deletionTechIdCollectionPredicate.evaluate(person, allowedRoles, deletionsToCheck);
        }
        return Status.OK;
    }

    private boolean isRegistrator(PersonPE person, DeletionPE value) {
        PersonPE registrator = value.getRegistrator();
        return person.getUserId().equals(registrator.getUserId()) && person.getDatabaseInstance().getCode().equals(registrator.getDatabaseInstance().getCode());
    }

    private static boolean isInstanceAdmin(PersonPE person) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            DatabaseInstancePE roleInstance = roleAssignment.getDatabaseInstance();
            if (roleInstance == null || !roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

