/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.batch;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.batch.IProgressAware;
import java.util.List;
import org.apache.log4j.Logger;

public class BatchOperationExecutor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, BatchOperationExecutor.class);
    private static final int DEFAULT_BATCH_SIZE = 999;

    public static <S> void executeInBatches(IBatchOperation<S> strategy) {
        BatchOperationExecutor.executeInBatches(strategy, 999);
    }

    public static <S> void executeInBatches(IBatchOperation<S> strategy, IServiceConversationProgressListener progressListenerOrNull, String progressPhaseOrNull) {
        BatchOperationExecutor.executeInBatches(strategy, 999, progressListenerOrNull, progressPhaseOrNull);
    }

    public static <S> void executeInBatches(IBatchOperation<S> strategy, int batchSize) {
        BatchOperationExecutor.executeInBatches(strategy, batchSize, null, null);
    }

    public static <S> void executeInBatches(IBatchOperation<S> strategy, int batchSize, IServiceConversationProgressListener progressListenerOrNull, String progressPhaseOrNull) {
        assert (strategy != null) : "Unspecified operation.";
        List<S> allEntities = strategy.getAllEntities();
        int maxIndex = allEntities.size();
        operationLog.debug(BatchOperationExecutor.getMemoryUsageMessage());
        BatchOperationExecutor.notifyProgressListener(progressListenerOrNull, progressPhaseOrNull, maxIndex, 0);
        operationLog.info(String.format("%s %s progress: %d/%d", strategy.getEntityName(), strategy.getOperationName(), 0, maxIndex));
        int startIndex = 0;
        int endIndex = Math.min(startIndex + batchSize, maxIndex);
        while (startIndex < maxIndex) {
            List<S> batch = allEntities.subList(startIndex, endIndex);
            if (strategy instanceof IProgressAware) {
                ((IProgressAware)((Object)strategy)).setNextChunk(startIndex, endIndex, maxIndex);
            }
            strategy.execute(batch);
            BatchOperationExecutor.notifyProgressListener(progressListenerOrNull, progressPhaseOrNull, maxIndex, endIndex);
            operationLog.info(String.format("%s %s progress: %d/%d", strategy.getEntityName(), strategy.getOperationName(), endIndex, maxIndex));
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(BatchOperationExecutor.getMemoryUsageMessage());
            }
            startIndex = endIndex;
            endIndex = Math.min(startIndex + batchSize, maxIndex);
        }
    }

    public static int getDefaultBatchSize() {
        return 999;
    }

    private static void notifyProgressListener(IServiceConversationProgressListener progressListenerOrNull, String progressPhaseOrNull, int maxIndex, int currentIndex) {
        if (progressListenerOrNull != null) {
            progressListenerOrNull.update(progressPhaseOrNull, maxIndex, currentIndex);
        }
    }

    private static String getMemoryUsageMessage() {
        Runtime runtime = Runtime.getRuntime();
        long mb = 0x100000L;
        long totalMemory = runtime.totalMemory() / mb;
        long freeMemory = runtime.freeMemory() / mb;
        long maxMemory = runtime.maxMemory() / mb;
        return "MEMORY (in MB): free:" + freeMemory + " total:" + totalMemory + " max:" + maxMemory;
    }
}

